/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class IdempotentLoopBodyInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitWhileStatement(PsiWhileStatement loop) {
                ControlFlow controlFlow;
                PsiExpression condition2 = loop.getCondition();
                if (condition2 == null || SideEffectChecker.mayHaveSideEffects(condition2)) {
                    return;
                }
                PsiStatement body2 = loop.getBody();
                if (body2 == null) {
                    return;
                }
                if (SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)body2)) {
                    return;
                }
                try {
                    controlFlow = ControlFlowFactory.getInstance(loop.getProject()).getControlFlow((PsiElement)body2, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                }
                catch (AnalysisCanceledException ignored) {
                    return;
                }
                this.checkControlFlow((PsiLoopStatement)loop, controlFlow, holder);
            }

            public void visitForStatement(PsiForStatement loop) {
                ControlFlow controlFlow;
                PsiExpression condition2 = loop.getCondition();
                if (condition2 != null && SideEffectChecker.mayHaveSideEffects(condition2)) {
                    return;
                }
                PsiStatement body2 = loop.getBody();
                if (body2 == null) {
                    return;
                }
                PsiStatement update2 = loop.getUpdate();
                if (SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)body2) || update2 != null && SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)update2)) {
                    return;
                }
                try {
                    controlFlow = ControlFlowFactory.getInstance(loop.getProject()).getControlFlow((PsiElement)loop, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                }
                catch (AnalysisCanceledException ignored) {
                    return;
                }
                int start = controlFlow.getStartOffset((PsiElement)body2);
                int end = controlFlow.getEndOffset((PsiElement)(update2 == null ? body2 : update2));
                if (start == -1 || end == -1) {
                    return;
                }
                controlFlow = new ControlFlowSubRange(controlFlow, start, end);
                this.checkControlFlow((PsiLoopStatement)loop, controlFlow, holder);
            }

            private void checkControlFlow(PsiLoopStatement loop, ControlFlow bodyFlow, @NotNull ProblemsHolder holder2) {
                Collection<PsiVariable> variables = ControlFlowUtil.getWrittenVariables(bodyFlow, 0, bodyFlow.getSize(), true);
                if (variables.isEmpty()) {
                    return;
                }
                List<PsiReferenceExpression> reads = ControlFlowUtil.getReadBeforeWrite(bodyFlow);
                if (StreamEx.of(reads).map(PsiReference::resolve).select(PsiVariable.class).noneMatch(variables::contains)) {
                    holder2.registerProblem(loop.getFirstChild(), JavaBundle.message((String)"inspection.idempotent.loop.body", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }
}

