/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.performance.CollectionsListSettings;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionAddAllCanBeReplacedWithConstructorInspection
extends AbstractBaseJavaLocalInspectionTool {
    private final CollectionsListSettings mySettings = new CollectionsListSettings(){

        @Override
        protected Collection<String> getDefaultSettings() {
            return Collections.emptyList();
        }
    };

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.mySettings.writeSettings(node);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.mySettings.createOptionsPanel();
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        this.mySettings.readSettings(node);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiNewExpression assignmentExpression;
                PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                PsiElement nameElement = methodExpression.getReferenceNameElement();
                String methodName = methodExpression.getReferenceName();
                if (nameElement == null || !"addAll".equals(methodName) && !"putAll".equals(methodName)) {
                    return;
                }
                PsiExpression[] args = expression2.getArgumentList().getExpressions();
                if (args.length != 1) {
                    return;
                }
                PsiExpressionStatement parent = (PsiExpressionStatement)ObjectUtils.tryCast((Object)expression2.getParent(), PsiExpressionStatement.class);
                if (parent == null) {
                    return;
                }
                PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable(methodExpression.getQualifierExpression());
                if (variable == null) {
                    return;
                }
                if (PsiUtil.resolveClassInClassTypeOnly((PsiType)variable.getType()) == null) {
                    return;
                }
                if (CollectionAddAllCanBeReplacedWithConstructorInspection.statementHasSubsequentAddAll((PsiElement)parent, variable, methodName)) {
                    return;
                }
                PsiType argType = args[0].getType();
                if (!InheritanceUtil.isInheritor((PsiType)argType, (String)("putAll".equals(methodName) ? "java.util.Map" : "java.util.Collection"))) {
                    return;
                }
                ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, (PsiStatement)parent);
                if (status == ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE || status == ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE_ONLY) {
                    if (!CollectionAddAllCanBeReplacedWithConstructorInspection.this.isCollectionConstructor(variable.getInitializer())) {
                        return;
                    }
                    assignmentExpression = (PsiNewExpression)variable.getInitializer();
                } else {
                    assignmentExpression = CollectionAddAllCanBeReplacedWithConstructorInspection.this.getPreviousAssignment(variable, (PsiStatement)parent);
                }
                if (assignmentExpression == null || !CollectionAddAllCanBeReplacedWithConstructorInspection.isAddAllReplaceable((PsiExpression)expression2, assignmentExpression)) {
                    return;
                }
                PsiMethod method = expression2.resolveMethod();
                if (method != null) {
                    holder.registerProblem(nameElement, QuickFixBundle.message("collection.addall.can.be.replaced.with.constructor.fix.description", new Object[0]), new LocalQuickFix[]{new ReplaceAddAllWithConstructorFix(assignmentExpression, expression2, methodName)});
                }
            }
        };
    }

    private PsiNewExpression getPreviousAssignment(PsiLocalVariable variable, PsiStatement statement) {
        do {
            if ((statement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class)) == null) {
                return null;
            }
            PsiExpression expression2 = ExpressionUtils.getAssignmentTo((PsiElement)statement, (PsiVariable)variable);
            if (!this.isCollectionConstructor(expression2)) continue;
            return (PsiNewExpression)expression2;
        } while (!VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)statement));
        return null;
    }

    private static boolean statementHasSubsequentAddAll(@NotNull PsiElement statement, @NotNull PsiLocalVariable referent, @NotNull String previousMethodName) {
        PsiMethod method;
        PsiMethodCallExpression siblingMethodCall;
        PsiExpression qualifier;
        PsiExpression siblingExpression;
        PsiElement sibling = PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        return sibling instanceof PsiExpressionStatement && (siblingExpression = ((PsiExpressionStatement)sibling).getExpression()) instanceof PsiMethodCallExpression && (qualifier = (siblingMethodCall = (PsiMethodCallExpression)siblingExpression).getMethodExpression().getQualifierExpression()) instanceof PsiReferenceExpression && referent.isEquivalentTo(((PsiReferenceExpression)qualifier).resolve()) && (method = siblingMethodCall.resolveMethod()) != null && method.getName().equals(previousMethodName);
    }

    private boolean isCollectionConstructor(PsiExpression initializer) {
        if (!(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
        if (classReference2 == null) {
            return false;
        }
        PsiClass initializerClass = (PsiClass)classReference2.resolve();
        if (initializerClass == null) {
            return false;
        }
        if (!(ConstructionUtils.isCollectionWithCopyConstructor(initializerClass) || this.mySettings.getCollectionClassesRequiringCapacity().contains(initializerClass.getQualifiedName()) && CollectionAddAllCanBeReplacedWithConstructorInspection.hasProperConstructor(initializerClass))) {
            return false;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        return argumentList != null && argumentList.isEmpty();
    }

    private static boolean hasProperConstructor(PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.getConstructors()) {
            PsiType type2;
            PsiParameter parameter2;
            PsiTypeElement typeElement;
            PsiParameterList parameterList = psiMethod.getParameterList();
            if (parameterList.getParametersCount() != 1 || (typeElement = (parameter2 = Objects.requireNonNull(parameterList.getParameter(0))).getTypeElement()) == null || !InheritanceUtil.isInheritor((PsiType)(type2 = typeElement.getType()), (String)"java.util.Collection") && !InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) continue;
            return true;
        }
        return false;
    }

    private static boolean isAddAllReplaceable(PsiExpression addAllExpression, PsiNewExpression newExpression) {
        final boolean[] isReplaceable = new boolean[]{true};
        final PsiFile newExpressionContainingFile = newExpression.getContainingFile();
        final TextRange newExpressionTextRange = newExpression.getTextRange();
        addAllExpression.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiVariable variable;
                LocalSearchScope useScope;
                PsiElement resolved = expression2.resolve();
                if (PsiUtil.isJvmLocalVariable((PsiElement)resolved) && !(useScope = (LocalSearchScope)(variable = (PsiVariable)resolved).getUseScope()).containsRange(newExpressionContainingFile, newExpressionTextRange)) {
                    isReplaceable[0] = false;
                }
            }
        });
        return isReplaceable[0];
    }

    private static class ReplaceAddAllWithConstructorFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCallExpression;
        private final SmartPsiElementPointer<PsiNewExpression> myNewExpression;
        private final String methodName;

        ReplaceAddAllWithConstructorFix(PsiNewExpression newExpression, PsiMethodCallExpression expression2, String methodName) {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)newExpression.getProject());
            this.myMethodCallExpression = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression2);
            this.myNewExpression = smartPointerManager.createSmartPsiElementPointer((PsiElement)newExpression);
            this.methodName = methodName;
        }

        @Nls
        @NotNull
        public String getName() {
            return QuickFixBundle.message("collection.addall.can.be.replaced.with.constructor.fix.name", this.methodName);
        }

        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("collection.addall.can.be.replaced.with.constructor.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.myMethodCallExpression.getElement();
            if (methodCallExpression == null) {
                return;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)methodCallExpression.getParent(), PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)this.myNewExpression.getElement();
            if (newExpression == null) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)newExpression.getParent());
            PsiVariable variable = null;
            if (parent instanceof PsiVariable) {
                variable = (PsiVariable)parent;
            } else if (parent instanceof PsiAssignmentExpression) {
                variable = ExpressionUtils.resolveLocalVariable(((PsiAssignmentExpression)parent).getLExpression());
            }
            if (variable == null) {
                return;
            }
            PsiJavaCodeReferenceElement reference = newExpression.getClassReference();
            if (reference == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiExpression parameter2 = methodCallExpression.getArgumentList().getExpressions()[0];
            String replacement = "new " + reference.getText() + "(" + ct.text((PsiElement)parameter2) + ")";
            if (parent instanceof PsiAssignmentExpression) {
                ct.delete(parent);
            } else {
                PsiElement scope;
                if (variable.getParent() instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)variable.getParent()).getDeclaredElements().length == 1 && (scope = PsiTreeUtil.getParentOfType((PsiElement)expressionStatement, (Class[])new Class[]{PsiMember.class, PsiStatement.class, PsiLambdaExpression.class})) != null && ReferencesSearch.search((PsiElement)variable).allMatch(ref -> PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)ref.getElement(), (boolean)true))) {
                    PsiDeclarationStatement newDeclaration = JavaPsiFacade.getElementFactory((Project)project).createVariableDeclarationStatement("x", (PsiType)PsiType.INT, null, (PsiElement)methodCallExpression);
                    PsiVariable newVariable = (PsiVariable)newDeclaration.getDeclaredElements()[0].replace((PsiElement)variable);
                    ct.delete((PsiElement)variable);
                    ct.replace((PsiElement)Objects.requireNonNull(newVariable.getInitializer()), replacement);
                    ct.replaceAndRestoreComments((PsiElement)expressionStatement, (PsiElement)newDeclaration);
                    return;
                }
                ct.delete((PsiElement)newExpression);
            }
            ct.replaceAndRestoreComments((PsiElement)methodCallExpression, variable.getName() + "=" + replacement);
        }
    }
}

