/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaSwitchStatementUnwrapper
extends JavaUnwrapper {
    public JavaSwitchStatementUnwrapper() {
        super("Unwrap 'switch' statement");
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        if (e instanceof PsiSwitchLabeledRuleStatement) {
            PsiSwitchLabeledRuleStatement switchLabeledRuleStatement = (PsiSwitchLabeledRuleStatement)e;
            return switchLabeledRuleStatement.getEnclosingSwitchBlock() instanceof PsiSwitchStatement;
        }
        if (e instanceof PsiStatement || e instanceof PsiWhiteSpace) {
            if (e.getNextSibling() instanceof PsiSwitchLabeledRuleStatement || e.getPrevSibling() instanceof PsiSwitchLabeledRuleStatement) {
                return false;
            }
            return e.getParent() instanceof PsiCodeBlock && e.getParent().getParent() instanceof PsiSwitchStatement;
        }
        return false;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return e.getParent().getParent();
    }

    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) {
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)element.getParent().getParent();
        if (element instanceof PsiSwitchLabeledRuleStatement) {
            PsiSwitchLabeledRuleStatement switchLabeledRuleStatement = (PsiSwitchLabeledRuleStatement)element;
            PsiStatement body2 = switchLabeledRuleStatement.getBody();
            if (body2 instanceof PsiBlockStatement) {
                context.extractFromCodeBlock(((PsiBlockStatement)body2).getCodeBlock(), (PsiElement)switchStatement);
            } else {
                context.extractElement((PsiElement)body2, (PsiElement)switchStatement);
            }
        } else {
            while (!(element instanceof PsiSwitchLabelStatement) && element != null) {
                element = PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PsiStatement.class);
            }
            while (element instanceof PsiSwitchLabelStatement) {
                element = PsiTreeUtil.getNextSiblingOfType((PsiElement)element, PsiStatement.class);
            }
            if (!(element instanceof PsiBreakStatement) && element != null) {
                block2: do {
                    if (element instanceof PsiSwitchLabelStatement) continue;
                    if (element instanceof PsiBlockStatement) {
                        PsiBlockStatement blockStatement = (PsiBlockStatement)element;
                        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                        PsiElement end = codeBlock.getLastBodyElement();
                        for (PsiElement start = codeBlock.getFirstBodyElement(); start != end && start != null; start = start.getNextSibling()) {
                            if (start instanceof PsiBreakStatement && ((PsiBreakStatement)start).getLabelIdentifier() == null) break block2;
                            JavaSwitchStatementUnwrapper.removeBreakStatements(start, switchStatement);
                            context.extractElement(start, (PsiElement)switchStatement);
                        }
                    } else {
                        JavaSwitchStatementUnwrapper.removeBreakStatements(element, switchStatement);
                        context.extractElement(element, (PsiElement)switchStatement);
                    }
                } while (!(element instanceof PsiBreakStatement) && !(element instanceof PsiContinueStatement) && !(element instanceof PsiThrowStatement) && !(element instanceof PsiReturnStatement) && (element = element.getNextSibling()) != null && !(element instanceof PsiJavaToken) && (!(element instanceof PsiBreakStatement) || ((PsiBreakStatement)element).getLabelIdentifier() != null));
            }
        }
        context.delete((PsiElement)switchStatement);
    }

    private static void removeBreakStatements(PsiElement element, PsiSwitchStatement switchStatement) {
        for (PsiBreakStatement breakStatement : PsiTreeUtil.findChildrenOfType((PsiElement)element, PsiBreakStatement.class)) {
            if (breakStatement.getLabelIdentifier() != null || breakStatement.findExitedStatement() != switchStatement) continue;
            breakStatement.delete();
        }
    }
}

