/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaMethodParameterUnwrapper
extends JavaUnwrapper {
    private static final Logger LOG = Logger.getInstance(JavaMethodParameterUnwrapper.class);

    public JavaMethodParameterUnwrapper() {
        super("");
    }

    private static PsiElement adjustElementToTheLeft(PsiElement element) {
        PsiElement prevSibling;
        if (PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RPARENTH) && (prevSibling = element.getPrevSibling()) != null) {
            return prevSibling;
        }
        return element;
    }

    @NotNull
    public String getDescription(@NotNull PsiElement e) {
        String text2 = JavaMethodParameterUnwrapper.adjustElementToTheLeft(e).getText();
        if (text2.length() > 20) {
            text2 = text2.substring(0, 17) + "...";
        }
        return CodeInsightBundle.message((String)"unwrap.with.placeholder", (Object[])new Object[]{text2});
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        PsiExpressionList argumentList;
        e = JavaMethodParameterUnwrapper.adjustElementToTheLeft(e);
        PsiElement parent = e.getParent();
        if (e instanceof PsiExpression) {
            PsiExpressionList argumentList2;
            if (parent instanceof PsiExpressionList) {
                return true;
            }
            if (e instanceof PsiReferenceExpression && parent instanceof PsiCallExpression && (argumentList2 = ((PsiCall)parent).getArgumentList()) != null && argumentList2.getExpressionCount() == 1) {
                return true;
            }
        } else if (e instanceof PsiJavaCodeReferenceElement && parent instanceof PsiCall && (argumentList = ((PsiCall)parent).getArgumentList()) != null && argumentList.getExpressionCount() == 1) {
            return true;
        }
        return false;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        e = JavaMethodParameterUnwrapper.adjustElementToTheLeft(e);
        super.collectAffectedElements(e, toExtract);
        return JavaMethodParameterUnwrapper.isTopLevelCall(e) ? e.getParent() : e.getParent().getParent();
    }

    private static boolean isTopLevelCall(PsiElement e) {
        if (e instanceof PsiReferenceExpression && e.getParent() instanceof PsiCallExpression) {
            return true;
        }
        return e instanceof PsiJavaCodeReferenceElement && !(e instanceof PsiExpression);
    }

    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiElement parent = (element = JavaMethodParameterUnwrapper.adjustElementToTheLeft(element)).getParent();
        if (parent == null) {
            return;
        }
        PsiElement methodCall = JavaMethodParameterUnwrapper.isTopLevelCall(element) ? parent : parent.getParent();
        PsiElement extractedElement = JavaMethodParameterUnwrapper.isTopLevelCall(element) ? JavaMethodParameterUnwrapper.getArg(element) : element;
        context.extractElement(extractedElement, methodCall);
        if (methodCall.getParent() instanceof PsiExpressionList) {
            context.delete(methodCall);
        } else {
            context.deleteExactly(methodCall);
        }
    }

    private static PsiExpression getArg(PsiElement element) {
        PsiExpressionList argumentList = ((PsiCall)element.getParent()).getArgumentList();
        LOG.assertTrue(argumentList != null);
        PsiExpression[] args = argumentList.getExpressions();
        LOG.assertTrue(args.length == 1);
        return args[0];
    }
}

