/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JavaElseUnwrapperBase
extends JavaUnwrapper {
    public JavaElseUnwrapperBase(String description) {
        super(description);
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return (PsiUtil.isElseBlock((PsiElement)e) || this.isElseKeyword(e)) && this.isValidConstruct(e);
    }

    private boolean isElseKeyword(PsiElement e) {
        PsiElement p = e.getParent();
        return p instanceof PsiIfStatement && e == ((PsiIfStatement)p).getElseElement();
    }

    private boolean isValidConstruct(PsiElement e) {
        return ((PsiIfStatement)e.getParent()).getElseBranch() != null;
    }

    public void collectElementsToIgnore(@NotNull PsiElement element, @NotNull Set<PsiElement> result) {
        PsiElement parent = element.getParent();
        while (parent instanceof PsiIfStatement) {
            result.add(parent);
            parent = parent.getParent();
        }
    }

    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiStatement elseBranch = this.isElseKeyword(element) ? ((PsiIfStatement)element.getParent()).getElseBranch() : (PsiStatement)element;
        this.unwrapElseBranch(elseBranch, element.getParent(), context);
    }

    protected abstract void unwrapElseBranch(PsiStatement var1, PsiElement var2, JavaUnwrapper.Context var3) throws IncorrectOperationException;
}

