/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates.editable;

import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public interface JavaPostfixTemplateExpressionCondition
extends PostfixTemplateExpressionCondition<PsiExpression> {

    public static class JavaPostfixTemplateArrayExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "array";

        public boolean value(@NotNull PsiExpression element) {
            return JavaPostfixTemplatesUtils.isArray(element.getType());
        }

        @NotNull
        public String getId() {
            return ID;
        }

        @NotNull
        public String getPresentableName() {
            return ID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateNotPrimitiveTypeExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "notPrimitive";

        public boolean value(@NotNull PsiExpression element) {
            return JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression(element);
        }

        @NotNull
        public String getId() {
            return ID;
        }

        @NotNull
        public String getPresentableName() {
            return "not primitive type";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateNumberExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "number";

        public boolean value(@NotNull PsiExpression element) {
            return JavaPostfixTemplatesUtils.isNumber(element.getType());
        }

        @NotNull
        public String getId() {
            return ID;
        }

        @NotNull
        public String getPresentableName() {
            return ID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateBooleanExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "boolean";

        public boolean value(@NotNull PsiExpression element) {
            return JavaPostfixTemplatesUtils.isBoolean(element.getType());
        }

        @NotNull
        public String getId() {
            return ID;
        }

        @NotNull
        public String getPresentableName() {
            return ID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateNonVoidExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "non void";

        public boolean value(@NotNull PsiExpression element) {
            return JavaPostfixTemplatesUtils.isNonVoid(element.getType());
        }

        @NotNull
        public String getId() {
            return ID;
        }

        @NotNull
        public String getPresentableName() {
            return ID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateVoidExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "void";

        public boolean value(@NotNull PsiExpression element) {
            PsiType type2 = element.getType();
            return type2 != null && PsiType.VOID.equals((Object)type2);
        }

        @NotNull
        public String getId() {
            return ID;
        }

        @NotNull
        public String getPresentableName() {
            return ID;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateExpressionFqnCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "fqn";
        public static final String FQN_ATTR = "fqn";
        private final String myFqn;

        public JavaPostfixTemplateExpressionFqnCondition(@NotNull String fqn) {
            this.myFqn = fqn;
        }

        public String getFqn() {
            return this.myFqn;
        }

        public boolean value(@NotNull PsiExpression element) {
            PsiType type2 = element.getType();
            return type2 != null && InheritanceUtil.isInheritor((PsiType)type2, (String)this.myFqn);
        }

        @NotNull
        public String getId() {
            return "fqn";
        }

        @NotNull
        public String getPresentableName() {
            return this.myFqn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaPostfixTemplateExpressionFqnCondition condition2 = (JavaPostfixTemplateExpressionFqnCondition)o;
            return Objects.equals(this.myFqn, condition2.myFqn);
        }

        public int hashCode() {
            return Objects.hash(this.myFqn);
        }

        public void serializeTo(@NotNull Element element) {
            JavaPostfixTemplateExpressionCondition.super.serializeTo(element);
            element.setAttribute("fqn", this.getFqn());
        }
    }
}

