/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TryWithResourcesPostfixTemplate
extends PostfixTemplate {
    protected TryWithResourcesPostfixTemplate() {
        super("twr", "try(Type f = new Type()) catch (Exception e)");
    }

    public boolean isApplicable(@NotNull PsiElement element, @NotNull Document copyDocument, int newOffset) {
        Project project;
        JavaPsiFacade facade;
        PsiClass autoCloseable;
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)element)) {
            return false;
        }
        PsiExpression initializer = JavaPostfixTemplatesUtils.getTopmostExpression(element);
        if (initializer == null) {
            return false;
        }
        PsiType type2 = initializer.getType();
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type2).resolve();
        return InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)(autoCloseable = (facade = JavaPsiFacade.getInstance((Project)(project = element.getProject()))).findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope((Project)project))), (boolean)true);
    }

    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        PsiExpression expression2 = JavaPostfixTemplatesUtils.getTopmostExpression(context);
        assert (expression2 != null);
        Project project = context.getProject();
        editor.getDocument().deleteString(expression2.getTextRange().getStartOffset(), expression2.getTextRange().getEndOffset());
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        template.addTextSegment("try (");
        MacroCallNode name2 = new MacroCallNode((Macro)new SuggestVariableNameMacro());
        template.addVariable("type", (Expression)new TypeExpression(project, new PsiType[]{expression2.getType()}), false);
        template.addTextSegment(" ");
        template.addVariable("name", (Expression)name2, (Expression)name2, true);
        template.addTextSegment(" = ");
        template.addVariable("variable", (Expression)new TextExpression(expression2.getText()), false);
        template.addTextSegment(") {\n");
        template.addEndVariable();
        template.addTextSegment("\n}");
        Collection<PsiClassType> unhandled = TryWithResourcesPostfixTemplate.getUnhandled(expression2);
        for (PsiClassType exception : unhandled) {
            MacroCallNode variable = new MacroCallNode((Macro)new SuggestVariableNameMacro());
            template.addTextSegment("catch(");
            template.addVariable("type " + exception.getClassName(), (Expression)new TypeExpression(project, new PsiType[]{exception}), false);
            template.addTextSegment(" ");
            template.addVariable("name " + exception.getClassName(), (Expression)variable, (Expression)variable, false);
            template.addTextSegment(") {}");
        }
        manager.startTemplate(editor, template);
    }

    @NotNull
    private static Collection<PsiClassType> getUnhandled(@NotNull PsiExpression expression2) {
        assert (expression2.getType() != null);
        return ExceptionUtil.getUnhandledCloserExceptions((PsiElement)expression2, null, expression2.getType());
    }
}

