/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelectorBase;
import com.intellij.codeInsight.template.postfix.templates.SurroundPostfixTemplateBase;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementPostfixTemplate
extends SurroundPostfixTemplateBase {
    private static final Condition<PsiElement> SWITCH_TYPE = expression2 -> {
        LanguageLevel level;
        PsiFile containingFile;
        PsiClass psiClass;
        if (!(expression2 instanceof PsiExpression)) {
            return false;
        }
        PsiType type2 = ((PsiExpression)expression2).getType();
        if (type2 == null) {
            return false;
        }
        if (PsiType.INT.isAssignableFrom(type2)) {
            return true;
        }
        if (type2 instanceof PsiClassType && (psiClass = ((PsiClassType)type2).resolve()) != null && psiClass.isEnum()) {
            return true;
        }
        return type2.equalsToText("java.lang.String") && (containingFile = expression2.getContainingFile()) instanceof PsiJavaFile && (level = ((PsiJavaFile)containingFile).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_7);
    };

    public SwitchStatementPostfixTemplate() {
        super("switch", "switch(expr)", JavaPostfixTemplatesUtils.JAVA_PSI_INFO, SwitchStatementPostfixTemplate.selectorTopmost(SWITCH_TYPE));
    }

    @NotNull
    protected Surrounder getSurrounder() {
        return new JavaExpressionSurrounder(){

            public boolean isApplicable(PsiExpression expr2) {
                return expr2.isPhysical() && SWITCH_TYPE.value((Object)expr2);
            }

            public TextRange surroundExpression(Project project, Editor editor, PsiExpression expr2) throws IncorrectOperationException {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                PsiElement parent = expr2.getParent();
                if (parent instanceof PsiExpressionStatement) {
                    PsiSwitchStatement switchStatement = (PsiSwitchStatement)factory.createStatementFromText("switch(1){case 1:}", null);
                    return this.postprocessSwitch(editor, expr2, codeStyleManager, parent, (PsiSwitchBlock)switchStatement);
                }
                if (HighlightingFeature.ENHANCED_SWITCH.isAvailable((PsiElement)expr2)) {
                    PsiSwitchExpression switchExpression = (PsiSwitchExpression)factory.createExpressionFromText("switch(1){case 1->1;}", null);
                    return this.postprocessSwitch(editor, expr2, codeStyleManager, (PsiElement)expr2, (PsiSwitchBlock)switchExpression);
                }
                return TextRange.from((int)editor.getCaretModel().getOffset(), (int)0);
            }

            @NotNull
            private TextRange postprocessSwitch(Editor editor, PsiExpression expr2, CodeStyleManager codeStyleManager, PsiElement toReplace, PsiSwitchBlock switchBlock) {
                PsiCodeBlock body2;
                PsiExpression selectorExpression = (switchBlock = (PsiSwitchBlock)codeStyleManager.reformat((PsiElement)switchBlock)).getExpression();
                if (selectorExpression != null) {
                    selectorExpression.replace((PsiElement)expr2);
                }
                if ((body2 = (switchBlock = (PsiSwitchBlock)toReplace.replace((PsiElement)switchBlock)).getBody()) != null) {
                    body2 = (PsiCodeBlock)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)body2);
                    TextRange range = body2.getStatements()[0].getTextRange();
                    editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
                    return TextRange.from((int)range.getStartOffset(), (int)0);
                }
                return TextRange.from((int)editor.getCaretModel().getOffset(), (int)0);
            }

            public String getTemplateDescription() {
                return "switch (expr) {...}";
            }
        };
    }

    public static PostfixTemplateExpressionSelector selectorTopmost(Condition<PsiElement> additionalFilter) {
        return new PostfixTemplateExpressionSelectorBase(additionalFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                boolean isEnhancedSwitchAvailable = HighlightingFeature.ENHANCED_SWITCH.isAvailable(context);
                ArrayList<PsiElement> result = new ArrayList<PsiElement>();
                PsiElement element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiExpression.class, PsiStatement.class});
                while (element instanceof PsiExpression) {
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiExpressionStatement) {
                        result.add(element);
                    } else if (isEnhancedSwitchAvailable && (this.isVariableInitializer(element, parent) || this.isRightSideOfAssignment(element, parent) || this.isReturnValue(element, parent) || this.isArgumentList(parent))) {
                        result.add(element);
                    }
                    element = element.getParent();
                }
                return result;
            }

            protected Condition<PsiElement> getFilters(int offset) {
                return Conditions.and((Condition)super.getFilters(offset), (Condition)this.getPsiErrorFilter());
            }

            @NotNull
            public Function<PsiElement, String> getRenderer() {
                return JavaPostfixTemplatesUtils.getRenderer();
            }

            private boolean isVariableInitializer(PsiElement element, PsiElement parent) {
                return parent instanceof PsiVariable && ((PsiVariable)parent).getInitializer() == element;
            }

            private boolean isRightSideOfAssignment(PsiElement element, PsiElement parent) {
                return parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getRExpression() == element;
            }

            private boolean isReturnValue(PsiElement element, PsiElement parent) {
                return parent instanceof PsiReturnStatement && ((PsiReturnStatement)parent).getReturnValue() == element;
            }

            private boolean isArgumentList(PsiElement parent) {
                return parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCall;
            }
        };
    }
}

