/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.postfix.templates.ArgumentPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.AssertStatementPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.CastExpressionPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.CastVarPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.ElseStatementPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.ForAscendingPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.ForDescendingPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.ForIndexedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.ForeachPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.FormatPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.IfStatementPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.InstanceofExpressionPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.IntroduceFieldPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.IntroduceVariablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.IsNullCheckPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.LambdaPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.NewExpressionPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.NotExpressionPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.NotNullCheckPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.ObjectsRequireNonNullPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.OptionalPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.ParenthesizedExpressionPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixLiveTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.template.postfix.templates.ReturnStatementPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.SerrPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.SoufPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.SoutPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.SoutvPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.StreamPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.SwitchStatementPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.SynchronizedStatementPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.ThrowExceptionPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.TryStatementPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.TryWithResourcesPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.WhileStatementPostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaEditablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaPostfixTemplateEditor;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaPostfixTemplateExpressionCondition;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class JavaPostfixTemplateProvider
implements PostfixTemplateProvider {
    private static final String LANGUAGE_LEVEL_ATTR = "language-level";
    private final Set<PostfixTemplate> myBuiltinTemplates = ContainerUtil.newHashSet((Object[])new PostfixTemplate[]{new AssertStatementPostfixTemplate(this), new SynchronizedStatementPostfixTemplate(this), new ForAscendingPostfixTemplate(this), new ForDescendingPostfixTemplate(this), new WhileStatementPostfixTemplate(this), new SoutPostfixTemplate(this), new SerrPostfixTemplate(this), new SoufPostfixTemplate(this), new SoutvPostfixTemplate(this), new ReturnStatementPostfixTemplate(this), new OptionalPostfixTemplate(this), new ForeachPostfixTemplate("iter", this), new ForeachPostfixTemplate("for", this), new LambdaPostfixTemplate(this), new ThrowExceptionPostfixTemplate(this), new FormatPostfixTemplate(this), new ObjectsRequireNonNullPostfixTemplate(this), new ArgumentPostfixTemplate(this), new CastExpressionPostfixTemplate(), new NewExpressionPostfixTemplate(), new CastVarPostfixTemplate(), new ElseStatementPostfixTemplate(), new IfStatementPostfixTemplate(), new InstanceofExpressionPostfixTemplate(), new InstanceofExpressionPostfixTemplate("inst"), new IntroduceFieldPostfixTemplate(), new IntroduceVariablePostfixTemplate(), new IsNullCheckPostfixTemplate(), new NotExpressionPostfixTemplate(), new NotExpressionPostfixTemplate("!"), new NotNullCheckPostfixTemplate(), new NotNullCheckPostfixTemplate("nn"), new ParenthesizedExpressionPostfixTemplate(), new SwitchStatementPostfixTemplate(), new TryStatementPostfixTemplate(), new TryWithResourcesPostfixTemplate(), new StreamPostfixTemplate()});

    @NotNull
    public Set<PostfixTemplate> getTemplates() {
        return this.myBuiltinTemplates;
    }

    @NotNull
    public String getId() {
        return "builtin.java";
    }

    @NotNull
    public String getPresentableName() {
        return "Java";
    }

    public boolean isTerminalSymbol(char currentChar) {
        return currentChar == '.' || currentChar == '!';
    }

    public void preExpand(@NotNull PsiFile file, @NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (JavaPostfixTemplateProvider.isSemicolonNeeded(file, editor)) {
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)";", (boolean)false, (boolean)false);
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
            }));
        }
    }

    public void afterExpand(@NotNull PsiFile file, @NotNull Editor editor) {
    }

    @NotNull
    public PsiFile preCheck(@NotNull PsiFile copyFile, @NotNull Editor realEditor, int currentOffset) {
        Document document = copyFile.getViewProvider().getDocument();
        assert (document != null);
        CharSequence sequence = document.getCharsSequence();
        StringBuilder fileContentWithSemicolon = new StringBuilder(sequence);
        if (JavaPostfixTemplateProvider.isSemicolonNeeded(copyFile, realEditor)) {
            fileContentWithSemicolon.insert(currentOffset, ';');
            return PostfixLiveTemplate.copyFile((PsiFile)copyFile, (StringBuilder)fileContentWithSemicolon);
        }
        return copyFile;
    }

    private static boolean isSemicolonNeeded(@NotNull PsiFile file, @NotNull Editor editor) {
        int startOffset = CompletionInitializationContext.calcStartOffset((Caret)editor.getCaretModel().getCurrentCaret());
        return JavaCompletionContributor.semicolonNeeded(file, startOffset);
    }

    @Nullable
    public PostfixTemplateEditor createEditor(@Nullable PostfixTemplate templateToEdit) {
        if (templateToEdit == null || templateToEdit instanceof JavaEditablePostfixTemplate && !(templateToEdit instanceof ForIndexedPostfixTemplate) && !(templateToEdit instanceof ForeachPostfixTemplate) && !(templateToEdit instanceof SoutvPostfixTemplate) && !(templateToEdit instanceof ArgumentPostfixTemplate) && !(templateToEdit instanceof OptionalPostfixTemplate)) {
            JavaPostfixTemplateEditor editor = new JavaPostfixTemplateEditor(this);
            editor.setTemplate(templateToEdit);
            return editor;
        }
        return null;
    }

    @Nullable
    public JavaEditablePostfixTemplate readExternalTemplate(@NotNull String id, @NotNull String name2, @NotNull Element template) {
        TemplateImpl liveTemplate = PostfixTemplatesUtils.readExternalLiveTemplate((Element)template, (PostfixTemplateProvider)this);
        if (liveTemplate == null) {
            return null;
        }
        Set conditions = PostfixTemplatesUtils.readExternalConditions((Element)template, JavaPostfixTemplateProvider::readExternal);
        boolean useTopmostExpression = PostfixTemplatesUtils.readExternalTopmostAttribute((Element)template);
        String languageLevelAttributeValue = template.getAttributeValue(LANGUAGE_LEVEL_ATTR);
        LanguageLevel languageLevel = (LanguageLevel)ObjectUtils.notNull((Object)LanguageLevel.parse((String)languageLevelAttributeValue), (Object)LanguageLevel.JDK_1_6);
        return new JavaEditablePostfixTemplate(id, name2, liveTemplate, "", (Set<JavaPostfixTemplateExpressionCondition>)conditions, languageLevel, useTopmostExpression, (PostfixTemplateProvider)this);
    }

    public void writeExternalTemplate(@NotNull PostfixTemplate template, @NotNull Element parentElement) {
        if (template instanceof JavaEditablePostfixTemplate) {
            LanguageLevel languageLevel = ((JavaEditablePostfixTemplate)template).getMinimumLanguageLevel();
            parentElement.setAttribute(LANGUAGE_LEVEL_ATTR, JpsJavaSdkType.complianceOption((JavaVersion)languageLevel.toJavaVersion()));
            PostfixTemplatesUtils.writeExternalTemplate((PostfixTemplate)template, (Element)parentElement);
        }
    }

    @Nullable
    private static JavaPostfixTemplateExpressionCondition readExternal(@NotNull Element condition2) {
        String fqn;
        String id = condition2.getAttributeValue("id");
        if ("array".equals(id)) {
            return new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateArrayExpressionCondition();
        }
        if ("non void".equals(id)) {
            return new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNonVoidExpressionCondition();
        }
        if ("void".equals(id)) {
            return new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateVoidExpressionCondition();
        }
        if ("boolean".equals(id)) {
            return new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateBooleanExpressionCondition();
        }
        if ("number".equals(id)) {
            return new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNumberExpressionCondition();
        }
        if ("notPrimitive".equals(id)) {
            return new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNotPrimitiveTypeExpressionCondition();
        }
        if ("fqn".equals(id) && StringUtil.isNotEmpty((String)(fqn = condition2.getAttributeValue("fqn")))) {
            return new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateExpressionFqnCondition(fqn);
        }
        return null;
    }
}

