/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class InstanceofExpressionPostfixTemplate
extends PostfixTemplate {
    public InstanceofExpressionPostfixTemplate() {
        this("instanceof");
    }

    public InstanceofExpressionPostfixTemplate(String alias) {
        super(alias, "expr instanceof Type ? ((Type) expr). : null");
    }

    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context instanceof PsiJavaToken && ((PsiJavaToken)context).getTokenType().equals(JavaTokenType.STRING_LITERAL)) {
            return false;
        }
        return JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression(JavaPostfixTemplatesUtils.getTopmostExpression(context));
    }

    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        PsiExpression expression2 = JavaPostfixTemplatesUtils.getTopmostExpression(context);
        if (!JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression(expression2)) {
            return;
        }
        InstanceofExpressionPostfixTemplate.surroundExpression(context.getProject(), editor, expression2);
    }

    private static void surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull PsiExpression expr2) throws IncorrectOperationException {
        TextRange range;
        assert (expr2.isValid());
        PsiType[] types = GuessManager.getInstance(project).guessTypeToCast(expr2);
        boolean parenthesesNeeded = expr2 instanceof PsiPolyadicExpression || expr2 instanceof PsiConditionalExpression || expr2 instanceof PsiAssignmentExpression;
        String exprText = parenthesesNeeded ? "(" + expr2.getText() + ")" : expr2.getText();
        Template template = InstanceofExpressionPostfixTemplate.generateTemplate(project, exprText, types);
        if (expr2.isPhysical()) {
            range = expr2.getTextRange();
        } else {
            RangeMarker rangeMarker = (RangeMarker)expr2.getUserData(ElementToWorkOn.TEXT_RANGE);
            if (rangeMarker == null) {
                PostfixTemplatesUtils.showErrorHint((Project)project, (Editor)editor);
                return;
            }
            range = new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        }
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
    }

    private static Template generateTemplate(Project project, String exprText, PsiType[] suggestedTypes) {
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        LinkedHashSet<PsiTypeLookupItem> itemSet = new LinkedHashSet<PsiTypeLookupItem>();
        for (PsiType type2 : suggestedTypes) {
            itemSet.add(PsiTypeLookupItem.createLookupItem(type2, null));
        }
        PsiTypeResult result = suggestedTypes.length > 0 ? new PsiTypeResult(suggestedTypes[0], project) : null;
        ConstantNode expr2 = new ConstantNode((Result)result).withLookupItems(itemSet.size() > 1 ? itemSet : Collections.emptySet());
        template.addTextSegment(exprText);
        template.addTextSegment(" instanceof ");
        String type3 = "type";
        template.addVariable(type3, (Expression)expr2, (Expression)expr2, true);
        template.addTextSegment(" ? ((");
        template.addVariableSegment(type3);
        template.addTextSegment(")" + exprText + ")");
        template.addEndVariable();
        template.addTextSegment(" : null;");
        return template;
    }
}

