/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuessElementTypeMacro
extends Macro {
    public String getName() {
        return "guessElementType";
    }

    public String getPresentableName() {
        return JavaBundle.message((String)"macro.guess.element.type.of.container", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        return "A";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        PsiType[] types = GuessElementTypeMacro.guessTypes(params, context);
        if (types == null || types.length == 0) {
            return null;
        }
        return new PsiTypeResult(types[0], context.getProject());
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        PsiType[] types = GuessElementTypeMacro.guessTypes(params, context);
        if (types == null || types.length < 2) {
            return null;
        }
        LinkedHashSet set = new LinkedHashSet();
        for (PsiType type2 : types) {
            JavaTemplateUtil.addTypeLookupItem(set, type2);
        }
        return set.toArray(LookupElement.EMPTY_ARRAY);
    }

    private static PsiType @Nullable [] guessTypes(Expression[] params, ExpressionContext context) {
        if (params.length != 1) {
            return null;
        }
        Result result = params[0].calculateResult(context);
        if (result == null) {
            return null;
        }
        Project project = context.getProject();
        PsiExpression expr2 = MacroUtil.resultToPsiExpression(result, context);
        if (expr2 == null) {
            return null;
        }
        PsiType[] types = GuessManager.getInstance(project).guessContainerElementType(expr2, new TextRange(context.getTemplateStartOffset(), context.getTemplateEndOffset()));
        for (int i = 0; i < types.length; ++i) {
            types[i] = GenericsUtil.getVariableTypeByExpressionType((PsiType)types[i]);
        }
        return types;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

