/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.JavaPsiElementResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DescendantClassesEnumMacro
extends Macro {
    public String getName() {
        return "descendantClassesEnum";
    }

    public String getPresentableName() {
        return JavaBundle.message((String)"macro.descendant.classes.enum", (Object[])new Object[0]);
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        List<PsiClass> classes2 = DescendantClassesEnumMacro.findDescendants(context, params);
        if (classes2 == null || classes2.size() == 0) {
            return null;
        }
        Result[] results = DescendantClassesEnumMacro.calculateResults(classes2);
        return results[0];
    }

    private static Result[] calculateResults(List<? extends PsiClass> classes2) {
        Result[] results = new Result[classes2.size()];
        int i = 0;
        for (PsiClass psiClass : classes2) {
            results[i++] = new JavaPsiElementResult((PsiElement)psiClass);
        }
        return results;
    }

    @Nullable
    private static List<PsiClass> findDescendants(ExpressionContext context, Expression[] params) {
        if (params == null || params.length == 0) {
            return null;
        }
        PsiManager instance = PsiManager.getInstance((Project)context.getProject());
        Result result = params[0].calculateResult(context);
        if (result == null) {
            return null;
        }
        String paramResult = result.toString();
        if (paramResult == null) {
            return null;
        }
        final boolean isAllowAbstract = DescendantClassesEnumMacro.isAllowAbstract(context, params);
        PsiClass myBaseClass = JavaPsiFacade.getInstance((Project)instance.getProject()).findClass(paramResult, GlobalSearchScope.allScope((Project)context.getProject()));
        if (myBaseClass != null) {
            final ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>();
            ClassInheritorsSearch.search((PsiClass)myBaseClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                public boolean execute(@NotNull PsiClass element) {
                    if (isAllowAbstract || !DescendantClassesEnumMacro.isAbstractOrInterface(element)) {
                        classes2.add(element);
                    }
                    return true;
                }
            }));
            return classes2;
        }
        return null;
    }

    public Result calculateQuickResult(Expression @NotNull [] params, ExpressionContext context) {
        List<PsiClass> classes2 = DescendantClassesEnumMacro.findDescendants(context, params);
        if (classes2 == null || classes2.size() == 0) {
            return null;
        }
        Result[] results = DescendantClassesEnumMacro.calculateResults(classes2);
        return results[0];
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context) {
        List<PsiClass> classes2 = DescendantClassesEnumMacro.findDescendants(context, params);
        if (classes2 == null || classes2.size() == 0) {
            return null;
        }
        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
        boolean isShortName = params.length > 1 && Boolean.valueOf(params[1].calculateResult(context).toString()) == false;
        for (PsiClass object : classes2) {
            String name2 = isShortName ? object.getName() : object.getQualifiedName();
            if (name2 == null || name2.length() <= 0) continue;
            set.add(LookupElementBuilder.create((String)name2));
        }
        return set.toArray(LookupElement.EMPTY_ARRAY);
    }

    private static boolean isAbstractOrInterface(PsiClass psiClass) {
        PsiModifierList modifierList = psiClass.getModifierList();
        return psiClass.isInterface() || modifierList != null && modifierList.hasModifierProperty("abstract");
    }

    private static boolean isAllowAbstract(ExpressionContext context, Expression[] params) {
        return params.length > 2 ? Boolean.valueOf(params[2].calculateResult(context).toString()) : true;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

