/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.java.JavaBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CodeBlockReformattingProcessor
implements TemplateOptionalProcessor,
DumbAware {
    public void processText(Project project, Template template, Document document, RangeMarker templateRange, Editor editor) {
        PsiJavaToken rBrace;
        PsiCodeBlock codeBlock;
        if (!template.isToReformat()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (!(file instanceof PsiJavaFile)) {
            return;
        }
        CharSequence text2 = document.getImmutableCharSequence();
        int prevChar = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(templateRange.getStartOffset() - 1), (String)" \t");
        int nextChar = CharArrayUtil.shiftForward((CharSequence)text2, (int)templateRange.getEndOffset(), (String)" \t");
        if (prevChar > 0 && text2.charAt(prevChar) == '{' && nextChar < text2.length() && text2.charAt(nextChar) == '}' && (codeBlock = (PsiCodeBlock)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)prevChar, PsiCodeBlock.class, (boolean)false)) != null && codeBlock.getTextRange().getStartOffset() == prevChar && (rBrace = codeBlock.getRBrace()) != null && rBrace.getTextRange().getStartOffset() == nextChar) {
            CodeEditUtil.markToReformat((ASTNode)rBrace.getNode(), (boolean)true);
        }
    }

    @Nls
    public String getOptionName() {
        return JavaBundle.message((String)"please.report.a.bug", (Object[])new Object[0]);
    }

    public boolean isEnabled(Template template) {
        return true;
    }

    public boolean isVisible(@NotNull Template template, @NotNull TemplateContext context) {
        return false;
    }
}

