/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.FilterUtil;
import org.jetbrains.annotations.NotNull;

public class KeywordLookupItem
extends LookupElement
implements TypedLookupItem {
    private final PsiElement myPosition;
    private final PsiKeyword myKeyword;

    public KeywordLookupItem(PsiKeyword keyword, @NotNull PsiElement position) {
        this.myKeyword = keyword;
        this.myPosition = position;
    }

    @NotNull
    public Object getObject() {
        return this.myKeyword;
    }

    @NotNull
    public String getLookupString() {
        return this.myKeyword.getText();
    }

    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE;
    }

    public boolean equals(Object o) {
        return o instanceof KeywordLookupItem && this.getLookupString().equals(((KeywordLookupItem)o).getLookupString());
    }

    public int hashCode() {
        return this.getLookupString().hashCode();
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
        presentation.setItemTextBold(true);
    }

    @Override
    public PsiType getType() {
        return FilterUtil.getKeywordItemType(this.myPosition, this.getLookupString());
    }
}

