/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.singlereturn;

import com.intellij.codeInsight.intention.impl.singlereturn.FinishMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class ExitContext {
    @NotNull
    private final PsiType myReturnType;
    @NotNull
    private final FinishMarker.FinishMarkerType myFinishMarkerType;
    private String myFinishedVariable;
    @NotNull
    private final PsiCodeBlock myBlock;
    @NotNull
    private final String myReturnVariable;
    @NotNull
    private final PsiElementFactory myFactory;
    private boolean myReturnVariableUsed = false;
    private final PsiExpression myReturnVariableDefaultValue;

    ExitContext(@NotNull PsiCodeBlock block, @NotNull PsiType returnType, @NotNull FinishMarker marker) {
        this.myBlock = block;
        this.myFactory = JavaPsiFacade.getElementFactory((Project)block.getProject());
        this.myReturnType = returnType;
        this.myReturnVariable = new VariableNameGenerator((PsiElement)block, VariableKind.LOCAL_VARIABLE).byName("result", "res").byType(returnType).generate(true);
        this.myReturnVariableDefaultValue = marker.myDefaultValue != null && PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)marker.myDefaultValue, (boolean)true) ? (PsiExpression)marker.myDefaultValue.copy() : marker.myDefaultValue;
        this.myFinishMarkerType = marker.myType;
    }

    String generateExitCondition() {
        switch (this.myFinishMarkerType) {
            case BOOLEAN_FALSE: {
                return "!" + this.myReturnVariable;
            }
            case BOOLEAN_TRUE: {
                return this.myReturnVariable;
            }
            case VALUE_EQUAL: {
                return this.myReturnVariable + "==" + this.myReturnVariableDefaultValue.getText();
            }
            case VALUE_NON_EQUAL: {
                return this.myReturnVariable + "!=" + this.myReturnVariableDefaultValue.getText();
            }
        }
        assert (this.myFinishedVariable != null);
        return this.myFinishedVariable;
    }

    String getNonExitCondition() {
        switch (this.myFinishMarkerType) {
            case BOOLEAN_FALSE: {
                return this.myReturnVariable;
            }
            case BOOLEAN_TRUE: {
                return "!" + this.myReturnVariable;
            }
            case VALUE_EQUAL: {
                return this.myReturnVariable + "!=" + this.myReturnVariableDefaultValue.getText();
            }
            case VALUE_NON_EQUAL: {
                return this.myReturnVariable + "==" + this.myReturnVariableDefaultValue.getText();
            }
        }
        assert (this.myFinishedVariable != null);
        return "!" + this.myFinishedVariable;
    }

    void registerReturnValue(PsiExpression value2, List<? super String> replacements) {
        this.myReturnVariableUsed = true;
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(this.myReturnVariableDefaultValue, value2)) {
            replacements.add(0, this.myReturnVariable + "=" + value2.getText() + ";");
        }
    }

    void register(List<String> replacements) {
        String assignment;
        if (this.myFinishMarkerType != FinishMarker.FinishMarkerType.SEPARATE_VAR) {
            return;
        }
        if (this.myFinishedVariable == null) {
            this.myFinishedVariable = new VariableNameGenerator((PsiElement)this.myBlock, VariableKind.LOCAL_VARIABLE).byName("finished", "completed").generate(true);
        }
        if (!replacements.contains(assignment = this.myFinishedVariable + "=true;")) {
            String first = (String)ContainerUtil.getFirstItem(replacements);
            int index = first != null && first.startsWith(this.myReturnVariable + "=") ? 1 : 0;
            replacements.add(index, assignment);
        }
    }

    PsiLocalVariable declareVariables() {
        PsiDeclarationStatement declaration2;
        PsiExpression initializer;
        PsiJavaToken start;
        if (this.myFinishedVariable != null) {
            start = Objects.requireNonNull(this.myBlock.getLBrace());
            initializer = this.myFactory.createExpressionFromText("false", null);
            declaration2 = this.myFactory.createVariableDeclarationStatement(this.myFinishedVariable, (PsiType)PsiType.BOOLEAN, initializer);
            PsiModifierList list = ((PsiLocalVariable)declaration2.getDeclaredElements()[0]).getModifierList();
            if (list != null) {
                list.setModifierProperty("final", false);
            }
            this.myBlock.addAfter((PsiElement)declaration2, (PsiElement)start);
        }
        if (this.myReturnVariableUsed) {
            PsiLocalVariable var;
            start = Objects.requireNonNull(this.myBlock.getLBrace());
            initializer = this.myReturnVariableDefaultValue;
            if (initializer == null && this.myFinishedVariable != null) {
                initializer = this.myFactory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)this.myReturnType), null);
            }
            if ((var = (PsiLocalVariable)((PsiDeclarationStatement)this.myBlock.addAfter((PsiElement)(declaration2 = this.myFactory.createVariableDeclarationStatement(this.myReturnVariable, this.myReturnType, initializer)), (PsiElement)start)).getDeclaredElements()[0]).hasModifierProperty("final") && !RefactoringUtil.canBeDeclaredFinal((PsiVariable)var)) {
                Objects.requireNonNull(var.getModifierList()).setModifierProperty("final", false);
            }
            return var;
        }
        return null;
    }

    public boolean isFinishCondition(PsiStatement statement) {
        if (!(statement instanceof PsiIfStatement)) {
            return false;
        }
        PsiExpression condition2 = ((PsiIfStatement)statement).getCondition();
        if (condition2 == null) {
            return false;
        }
        if (BoolUtils.isNegation(condition2)) {
            condition2 = BoolUtils.getNegated(condition2);
        }
        if (condition2 instanceof PsiBinaryExpression) {
            condition2 = ((PsiBinaryExpression)condition2).getLOperand();
        }
        if (!(condition2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)condition2;
        return ref.getQualifierExpression() == null && (Objects.equals(this.myFinishedVariable, ref.getReferenceName()) || Objects.equals(this.myReturnVariable, ref.getReferenceName()));
    }

    boolean isDefaultReturn(PsiStatement statement) {
        if (this.myReturnVariableDefaultValue != null && statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(this.myReturnVariableDefaultValue, returnStatement.getReturnValue()) && !FinishMarker.mayNeedMarker(returnStatement, this.myBlock);
        }
        return false;
    }
}

