/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.singlereturn;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.singlereturn.ExitContext;
import com.intellij.codeInsight.intention.impl.singlereturn.FinishMarker;
import com.intellij.codeInsight.intention.impl.singlereturn.ReturnReplacementContext;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToSingleReturnAction
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiCodeBlock block = ConvertToSingleReturnAction.findBlock(element);
        if (block == null) {
            return;
        }
        ThrowableComputable bodyGenerator = () -> ConvertToSingleReturnAction.generateBody(project, block, ProgressManager.getInstance().getProgressIndicator());
        PsiCodeBlock replacement = (PsiCodeBlock)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (PsiCodeBlock)ReadAction.compute((ThrowableComputable)bodyGenerator), StringUtil.toTitleCase((String)this.getFamilyName()), true, project);
        if (replacement != null) {
            Runnable action = () -> CodeStyleManager.getInstance((Project)project).reformat(block.replace((PsiElement)replacement));
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, (Runnable)action, (PsiFile[])new PsiFile[]{element.getContainingFile()});
        }
    }

    @Nullable
    private static PsiCodeBlock generateBody(@NotNull Project project, PsiCodeBlock block, ProgressIndicator indicator) {
        indicator.setIndeterminate(false);
        PsiType returnType = PsiTypesUtil.getMethodReturnType((PsiElement)block);
        if (returnType == null) {
            return null;
        }
        List<PsiReturnStatement> returns = Arrays.asList(PsiUtil.findReturnStatements((PsiCodeBlock)block));
        indicator.checkCanceled();
        indicator.setFraction(0.1);
        FinishMarker marker = FinishMarker.defineFinishMarker(block, returnType, returns);
        indicator.checkCanceled();
        indicator.setFraction(0.2);
        PsiCodeBlock copy = (PsiCodeBlock)block.copy();
        indicator.checkCanceled();
        indicator.setFraction(0.3);
        PsiLocalVariable variable = ConvertToSingleReturnAction.convertReturns(project, copy, returnType, marker, returns.size(), indicator);
        if (variable != null) {
            PsiJavaToken end = Objects.requireNonNull(copy.getRBrace());
            copy.addBefore((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("return " + variable.getName() + ";", (PsiElement)copy), (PsiElement)end);
        }
        return copy;
    }

    public static PsiLocalVariable convertReturns(@NotNull Project project, PsiCodeBlock block, PsiType returnType, FinishMarker marker, int count, ProgressIndicator indicator) {
        ExitContext exitContext = new ExitContext(block, returnType, marker);
        int i = 0;
        while (true) {
            indicator.checkCanceled();
            indicator.setFraction(0.3 + 0.6 * (double)i++ / (double)count);
            ProgressManager.checkCanceled();
            PsiReturnStatement returnStatement = ConvertToSingleReturnAction.getNonTerminalReturn(block);
            if (returnStatement == null) break;
            ReturnReplacementContext.replaceSingleReturn(project, block, exitContext, returnStatement);
        }
        indicator.setFraction(0.9);
        PsiLocalVariable resultVariable = exitContext.declareVariables();
        indicator.setFraction(0.92);
        return resultVariable;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiCodeBlock block = ConvertToSingleReturnAction.findBlock(element);
        if (block == null) {
            return false;
        }
        PsiType returnType = PsiTypesUtil.getMethodReturnType((PsiElement)block);
        return returnType != null && ConvertToSingleReturnAction.getNonTerminalReturn(block) != null;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nullable
    private static PsiCodeBlock findBlock(PsiElement element) {
        PsiParameterListOwner owner2 = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameterListOwner.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class});
        if (owner2 == null) {
            return null;
        }
        return (PsiCodeBlock)ObjectUtils.tryCast((Object)owner2.getBody(), PsiCodeBlock.class);
    }

    private static PsiReturnStatement getNonTerminalReturn(@NotNull PsiCodeBlock block) {
        PsiStatement lastStatement = (PsiStatement)ArrayUtil.getLastElement((Object[])block.getStatements());
        if (lastStatement == null) {
            return null;
        }
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            private PsiReturnStatement myReturnStatement;
            final /* synthetic */ PsiStatement val$lastStatement;

            Visitor(PsiStatement psiStatement) {
                this.val$lastStatement = psiStatement;
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                super.visitReturnStatement(statement);
                if (this.val$lastStatement != statement) {
                    this.myReturnStatement = statement;
                    this.stopWalking();
                }
            }

            public void visitExpression(PsiExpression expression2) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            public void visitClass(PsiClass aClass) {
            }
        }
        Visitor visitor2 = new Visitor(lastStatement);
        block.accept((PsiElementVisitor)visitor2);
        return visitor2.myReturnStatement;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.convert.to.single.return.name", (Object[])new Object[0]);
    }
}

