/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.lists;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaListUtils {
    private JavaListUtils() {
    }

    @Nullable
    static PsiElement prevBreak(@NotNull PsiElement element) {
        for (PsiElement current = element.getPrevSibling(); current != null && JavaListUtils.isValidIntermediateElement(current); current = current.getPrevSibling()) {
            if (!(current instanceof PsiWhiteSpace) || !current.textContains('\n')) continue;
            return current;
        }
        return null;
    }

    @Nullable
    static PsiElement nextBreak(@NotNull PsiElement element) {
        for (PsiElement current = element.getNextSibling(); current != null && JavaListUtils.isValidIntermediateElement(current); current = current.getNextSibling()) {
            if (!(current instanceof PsiWhiteSpace) || !current.textContains('\n')) continue;
            return current;
        }
        return null;
    }

    static boolean containsEolComments(@NotNull List<? extends PsiElement> elements) {
        PsiElement parent = elements.get(0).getParent();
        for (PsiElement child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiComment) || ((PsiComment)child).getTokenType() != JavaTokenType.END_OF_LINE_COMMENT) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidIntermediateElement(@NotNull PsiElement element) {
        return element instanceof PsiWhiteSpace || element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.COMMA;
    }

    @Nullable
    static PsiExpressionList getCallArgumentsList(@NotNull PsiElement element) {
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionList.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class});
        if (expressionList == null) {
            return null;
        }
        PsiElement parent = expressionList.getParent();
        if (!(parent instanceof PsiCall)) {
            return null;
        }
        return expressionList;
    }
}

