/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.lists;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.impl.lists.AbstractJavaChopListAction;
import com.intellij.codeInsight.intention.impl.lists.JavaListUtils;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChopArgumentsAction
extends AbstractJavaChopListAction<PsiExpressionList, PsiExpression> {
    @Override
    @Nullable(value="When failed")
    @Nullable(value="When failed") PsiExpressionList extractList(@NotNull PsiElement element) {
        return JavaListUtils.getCallArgumentsList(element);
    }

    @Override
    @Nullable(value="When failed")
    @Nullable(value="When failed") List<PsiExpression> getElements(@NotNull PsiExpressionList list) {
        return Arrays.asList(list.getExpressions());
    }

    @Override
    boolean needTailBreak(@NotNull PsiExpression last) {
        return CodeStyle.getLanguageSettings((PsiFile)last.getContainingFile(), (Language)JavaLanguage.INSTANCE).CALL_PARAMETERS_RPAREN_ON_NEXT_LINE;
    }

    @Override
    boolean needHeadBreak(@NotNull PsiExpression first) {
        return CodeStyle.getLanguageSettings((PsiFile)first.getContainingFile(), (Language)JavaLanguage.INSTANCE).CALL_PARAMETERS_RPAREN_ON_NEXT_LINE;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.family.put.arguments.on.separate.lines", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }
}

