/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnrollLoopAction
extends PsiElementBaseIntentionAction {
    private static final int MAX_BODY_SIZE_ESTIMATE = 5000;

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class);
        PsiVariable iterationParameter = UnrollLoopAction.getVariable(loop);
        if (iterationParameter == null || !(loop.getParent() instanceof PsiCodeBlock)) {
            return false;
        }
        List<PsiExpression> expressions2 = UnrollLoopAction.extractExpressions(loop);
        PsiStatement body2 = loop.getBody();
        if (body2 == null) {
            return false;
        }
        if (expressions2.isEmpty() || expressions2.size() > 5000 || (expressions2.size() - 1) * body2.getTextLength() > 5000) {
            return false;
        }
        PsiStatement[] statements = ControlFlowUtils.unwrapBlock(body2);
        if (statements.length == 0) {
            return false;
        }
        if (Arrays.stream(statements).anyMatch(PsiDeclarationStatement.class::isInstance)) {
            return false;
        }
        if (VariableAccessUtils.variableIsAssigned(iterationParameter, (PsiElement)body2)) {
            return false;
        }
        for (PsiStatement statement : statements) {
            boolean acceptable;
            if (UnrollLoopAction.isLoopBreak(statement) || (acceptable = PsiTreeUtil.processElements((PsiElement)statement, e -> {
                if (e instanceof PsiBreakStatement && ((PsiBreakStatement)e).findExitedStatement() == loop) {
                    return false;
                }
                return !(e instanceof PsiContinueStatement) || ((PsiContinueStatement)e).findContinuedStatement() != loop;
            }))) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiVariable getVariable(PsiLoopStatement loop) {
        CountingLoop countingLoop;
        if (loop instanceof PsiForeachStatement) {
            return ((PsiForeachStatement)loop).getIterationParameter();
        }
        if (loop instanceof PsiForStatement && (countingLoop = CountingLoop.from((PsiForStatement)loop)) != null) {
            return countingLoop.getCounter();
        }
        return null;
    }

    @NotNull
    private static List<PsiExpression> extractExpressions(PsiLoopStatement loop) {
        CountingLoop countingLoop;
        if (loop instanceof PsiForeachStatement) {
            PsiExpression expression2 = ExpressionUtils.resolveExpression(((PsiForeachStatement)loop).getIteratedValue());
            if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiArrayInitializerExpression) {
                return Arrays.asList(((PsiArrayInitializerExpression)expression2).getInitializers());
            }
            if (expression2 instanceof PsiNewExpression) {
                PsiArrayInitializerExpression initializer = ((PsiNewExpression)expression2).getArrayInitializer();
                return initializer == null ? Collections.emptyList() : Arrays.asList(initializer.getInitializers());
            }
            if (expression2 instanceof PsiMethodCallExpression) {
                PsiClass enumClass;
                PsiType type2;
                PsiExpression[] args;
                PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
                if (Holder.SINGLETON_CONSTRUCTOR.test(call)) {
                    return Arrays.asList(call.getArgumentList().getExpressions());
                }
                if (Holder.LIST_CONSTRUCTOR.test(call) && ((args = call.getArgumentList().getExpressions()).length > 1 || MethodCallUtils.isVarArgCall((PsiCall)call))) {
                    return Arrays.asList(args);
                }
                if (CallMatcher.enumValues().test(call) && (type2 = call.getType()) instanceof PsiArrayType && (enumClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiArrayType)type2).getComponentType())) != null && enumClass.isEnum()) {
                    List constants = StreamEx.of((Object[])enumClass.getFields()).select(PsiEnumConstant.class).toList();
                    return UnrollLoopAction.generatedList((PsiElement)loop, constants.size(), index -> enumClass.getQualifiedName() + "." + ((PsiEnumConstant)constants.get(index)).getName());
                }
            }
            if (ExpressionUtils.isSafelyRecomputableExpression(expression2)) {
                Integer listSize;
                DfType dfType;
                Integer arraySize;
                PsiType type3 = expression2.getType();
                if (type3 instanceof PsiArrayType && (arraySize = DfConstantType.getConstantOfType(SpecialField.ARRAY_LENGTH.getFromQualifier(dfType = CommonDataflow.getDfType(expression2)), Integer.class)) != null) {
                    PsiExpression array = expression2;
                    return UnrollLoopAction.generatedList((PsiElement)loop, arraySize, index -> ParenthesesUtils.getText(array, 2) + "[" + index + "]");
                }
                if (InheritanceUtil.isInheritor((PsiType)type3, (String)"java.util.List") && (listSize = DfConstantType.getConstantOfType(SpecialField.COLLECTION_SIZE.getFromQualifier(dfType = CommonDataflow.getDfType(expression2)), Integer.class)) != null) {
                    PsiExpression list = expression2;
                    return UnrollLoopAction.generatedList((PsiElement)loop, listSize, index -> ParenthesesUtils.getText(list, 1) + ".get(" + index + ")");
                }
            }
        }
        if (loop instanceof PsiForStatement && (countingLoop = CountingLoop.from((PsiForStatement)loop)) != null) {
            String suffix;
            boolean descending = countingLoop.isDescending();
            long multiplier = descending ? -1L : 1L;
            Object from = CommonDataflow.computeValue(countingLoop.getInitializer());
            if (!(from instanceof Integer) && !(from instanceof Long)) {
                return Collections.emptyList();
            }
            long fromValue = ((Number)from).longValue();
            Object to = CommonDataflow.computeValue(countingLoop.getBound());
            if (!(to instanceof Integer) && !(to instanceof Long)) {
                return Collections.emptyList();
            }
            long toValue = ((Number)to).longValue();
            long diff = multiplier * (toValue - fromValue);
            String string = suffix = PsiType.LONG.equals((Object)countingLoop.getCounter().getType()) ? "L" : "";
            if (countingLoop.isIncluding()) {
                ++diff;
            }
            if (diff < 0L || diff > 5000L) {
                return Collections.emptyList();
            }
            int size = (int)diff;
            return UnrollLoopAction.generatedList((PsiElement)loop, size, index -> fromValue + multiplier * (long)index + suffix);
        }
        return Collections.emptyList();
    }

    private static List<PsiExpression> generatedList(final PsiElement context, final int size, final IntFunction<String> generator) {
        final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        return new AbstractList<PsiExpression>(){

            @Override
            public PsiExpression get(int index) {
                return factory.createExpressionFromText((String)generator.apply(index), context);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.unroll.loop.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiExpression iteratedValue2;
        PsiLocalVariable variable;
        PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class);
        if (loop == null) {
            return;
        }
        if (!(loop.getParent() instanceof PsiCodeBlock)) {
            return;
        }
        List<PsiExpression> expressions2 = UnrollLoopAction.extractExpressions(loop);
        if (expressions2.isEmpty()) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CommentTracker ct = new CommentTracker();
        PsiLoopStatement anchor = loop;
        for (PsiExpression expression2 : expressions2) {
            PsiElement[] children;
            ct.markUnchanged(loop.getBody());
            PsiLoopStatement copy = (PsiLoopStatement)factory.createStatementFromText(loop.getText(), element);
            PsiVariable variable2 = Objects.requireNonNull(UnrollLoopAction.getVariable(copy));
            for (PsiReference reference : ReferencesSearch.search((PsiElement)variable2, (SearchScope)new LocalSearchScope((PsiElement)copy))) {
                PsiElement referenceElement = reference.getElement();
                if (!(referenceElement instanceof PsiJavaCodeReferenceElement)) continue;
                ct.markUnchanged(expression2);
                InlineUtil.inlineVariable(variable2, expression2, (PsiJavaCodeReferenceElement)referenceElement);
            }
            PsiStatement body2 = copy.getBody();
            assert (body2 != null);
            if (body2 instanceof PsiBlockStatement) {
                children = ((PsiBlockStatement)body2).getCodeBlock().getChildren();
                children = Arrays.copyOfRange(children, 1, children.length - 1);
            } else {
                children = new PsiElement[]{body2};
            }
            for (PsiElement child : children) {
                PsiElement added = anchor.getParent().addBefore(child, (PsiElement)anchor);
                if (!(added instanceof PsiIfStatement) || !UnrollLoopAction.isLoopBreak((PsiStatement)added)) continue;
                PsiIfStatement ifStatement = (PsiIfStatement)added;
                PsiExpression condition2 = Objects.requireNonNull(ifStatement.getCondition());
                PsiStatement thenBranch = Objects.requireNonNull(ifStatement.getThenBranch());
                String negated = BoolUtils.getNegatedExpressionText(condition2, ct);
                condition2.replace((PsiElement)factory.createExpressionFromText(negated, (PsiElement)condition2));
                PsiBlockStatement block = (PsiBlockStatement)thenBranch.replace((PsiElement)factory.createStatementFromText("{}", added));
                anchor = block.getCodeBlock().getLastChild();
            }
        }
        if (loop instanceof PsiForeachStatement && (variable = ExpressionUtils.resolveLocalVariable(iteratedValue2 = ((PsiForeachStatement)loop).getIteratedValue())) != null && PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)((PsiElement)expressions2.get(0)), (boolean)true)) {
            ct.delete((PsiElement)variable);
        }
        ct.deleteAndRestoreComments((PsiElement)loop);
    }

    private static boolean isLoopBreak(PsiStatement statement) {
        if (!(statement instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)statement;
        if (ifStatement.getElseBranch() != null || ifStatement.getCondition() == null) {
            return false;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        return thenBranch instanceof PsiBreakStatement && ((PsiBreakStatement)thenBranch).getLabelIdentifier() == null;
    }

    private static class Holder {
        private static final CallMatcher LIST_CONSTRUCTOR = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Arrays", "asList"), CallMatcher.staticCall("java.util.List", "of"));
        private static final CallMatcher SINGLETON_CONSTRUCTOR = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "singleton", "singletonList").parameterCount(1), CallMatcher.staticCall("java.util.List", "of").parameterTypes("E"));

        private Holder() {
        }
    }
}

