/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class SplitDeclarationAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.split.declaration.family", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!SplitDeclarationAction.canModify((PsiElement)element)) {
            return false;
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        PsiDeclarationStatement context = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class, (boolean)false, (Class[])new Class[]{PsiClass.class, PsiCodeBlock.class});
        return context != null && this.isAvailableOnDeclarationStatement(context);
    }

    private boolean isAvailableOnDeclarationStatement(PsiDeclarationStatement decl) {
        PsiElement[] declaredElements = decl.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        if (!(declaredElements[0] instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable var = (PsiLocalVariable)declaredElements[0];
        if (var.getInitializer() == null) {
            return false;
        }
        if (var.getTypeElement().isInferredType() && !PsiTypesUtil.isDenotableType((PsiType)var.getType(), (PsiElement)var)) {
            return false;
        }
        PsiElement parent = decl.getParent();
        if (parent instanceof PsiForStatement) {
            final String varName = var.getName();
            for (parent = parent.getNextSibling(); parent != null; parent = parent.getNextSibling()) {
                final Ref conflictFound = new Ref((Object)false);
                parent.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitVariable(PsiVariable variable) {
                        super.visitVariable(variable);
                        if (varName.equals(variable.getName())) {
                            conflictFound.set((Object)true);
                            this.stopWalking();
                        }
                    }
                });
                if (!((Boolean)conflictFound.get()).booleanValue()) continue;
                return false;
            }
        }
        this.setText(JavaBundle.message((String)"intention.split.declaration.assignment.text", (Object[])new Object[0]));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiDeclarationStatement decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class);
        if (decl != null) {
            ExpressionUtils.splitDeclaration(decl, project);
        }
    }
}

