/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.google.common.collect.Comparators;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortContentAction
extends PsiElementBaseIntentionAction {
    public static final int MIN_ELEMENTS_COUNT = 3;

    @Nls
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.family.sort.content", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        for (Sortable sortable : Holder.OUR_SORTABLES) {
            if (!sortable.isAvailable(element)) continue;
            sortable.replaceWithSorted(element);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        for (Sortable sortable : Holder.OUR_SORTABLES) {
            if (!sortable.isAvailable(element)) continue;
            return true;
        }
        return false;
    }

    private static class EnumConstantDeclarationSortable
    extends Sortable<EnumContext> {
        private EnumConstantDeclarationSortable() {
        }

        @Override
        boolean isEnd(@NotNull PsiElement element) {
            IElementType tokenType;
            return element instanceof PsiJavaToken && ((tokenType = ((PsiJavaToken)element).getTokenType()) == JavaTokenType.SEMICOLON || tokenType == JavaTokenType.RBRACE);
        }

        @Override
        SortingStrategy @NotNull [] sortStrategies() {
            return new SortingStrategy[]{new EnumConstantDeclarationSortingStrategy()};
        }

        @Override
        @Nullable
        EnumContext getContext(@NotNull PsiElement origin) {
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)origin, PsiClass.class);
            if (aClass == null) {
                return null;
            }
            if (!aClass.isEnum()) {
                return null;
            }
            PsiEnumConstant[] constants = (PsiEnumConstant[])PsiTreeUtil.getChildrenOfType((PsiElement)aClass, PsiEnumConstant.class);
            if (constants == null || constants.length < 3) {
                return null;
            }
            PsiEnumConstant last = constants[constants.length - 1];
            PsiElement lastEnumRelatedElement = EnumConstantDeclarationSortable.getLastEnumDeclarationRelatedElement(last);
            if (lastEnumRelatedElement.getTextRange().getEndOffset() <= origin.getTextOffset()) {
                return null;
            }
            PsiElement lBrace = aClass.getLBrace();
            if (lBrace == null) {
                return null;
            }
            PsiElement nextAfterLbrace = lBrace.getNextSibling();
            if (nextAfterLbrace == null) {
                return null;
            }
            return new EnumContext(Arrays.asList(constants), nextAfterLbrace);
        }

        @NotNull
        private static PsiElement getLastEnumDeclarationRelatedElement(@NotNull PsiEnumConstant last) {
            PsiElement current = last.getNextSibling();
            while (current instanceof PsiWhiteSpace || current instanceof PsiComment || current instanceof PsiJavaToken && ((PsiJavaToken)current).getTokenType() == JavaTokenType.COMMA) {
                current = current.getNextSibling();
            }
            return current;
        }

        @Override
        @NotNull
        List<PsiElement> getElements(@NotNull EnumContext context) {
            return new ArrayList<PsiElement>(context.myEnumConstants);
        }

        @Override
        PsiElement getFirst(EnumContext context) {
            return context.myFirst;
        }

        @Override
        void replaceWithSorted(PsiElement origin) {
            PsiClass anEnum;
            EnumContext context = this.getContext(origin);
            if (context == null) {
                return;
            }
            SortableList sortableList = this.readEntries(context);
            if (sortableList == null) {
                return;
            }
            PsiElement lastElement = sortableList.getLastElement();
            sortableList.sort();
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)origin, PsiClass.class);
            if (aClass == null) {
                return;
            }
            String name2 = aClass.getName();
            if (name2 == null) {
                return;
            }
            PsiElement lBrace = aClass.getLBrace();
            PsiElement rBrace = aClass.getRBrace();
            if (lBrace == null || rBrace == null) {
                return;
            }
            for (SortableEntry entry : sortableList.myEntries) {
                List comments = ((StreamEx)StreamEx.ofTree((Object)entry.myElement, el -> StreamEx.of((Object[])el.getChildren())).select(PsiComment.class).filter(comment -> !(comment instanceof PsiDocComment))).toList();
                for (PsiComment comment2 : comments) {
                    entry.myBeforeSeparator.add((PsiComment)comment2.copy());
                    comment2.delete();
                }
            }
            StringBuilder sb = new StringBuilder();
            if (sortableList.generate(sb)) {
                sb.append("\n");
            }
            for (PsiElement elementToPreserve = lastElement.getNextSibling(); elementToPreserve != null && elementToPreserve != rBrace; elementToPreserve = elementToPreserve.getNextSibling()) {
                sb.append(elementToPreserve.getText());
            }
            Project project = aClass.getProject();
            PsiClass newEnum = EnumConstantDeclarationSortable.createEnum(project, sb.toString());
            if (newEnum == null) {
                return;
            }
            PsiElement newClassLBrace = newEnum.getLBrace();
            PsiElement newClassRBrace = newEnum.getRBrace();
            if (newClassLBrace == null || newClassRBrace == null) {
                return;
            }
            aClass.deleteChildRange(lBrace, rBrace);
            StringBuilder finalText = new StringBuilder();
            for (PsiElement current = newClassLBrace.getNextSibling(); current != newClassRBrace; current = current.getNextSibling()) {
                finalText.append(current.getText());
            }
            String prefix = aClass.getText();
            PsiElement lastChild = aClass.getLastChild();
            if (lastChild instanceof PsiComment && ((PsiComment)lastChild).getTokenType() == JavaTokenType.END_OF_LINE_COMMENT) {
                prefix = prefix + "\n";
            }
            if ((anEnum = EnumConstantDeclarationSortable.createEnum(project, finalText.toString(), prefix)) != null) {
                aClass.replace((PsiElement)anEnum);
            }
        }

        private static PsiClass createEnum(Project project, String text2, String prefix) {
            String enumText = prefix + " {" + text2 + "}";
            PsiJavaFile file = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_DUMMY_", (FileType)JavaFileType.INSTANCE, (CharSequence)enumText);
            PsiClass[] classes2 = file.getClasses();
            if (classes2.length != 1) {
                return null;
            }
            return classes2[0];
        }

        private static PsiClass createEnum(Project project, String text2) {
            return EnumConstantDeclarationSortable.createEnum(project, text2, "enum __DUMMY__");
        }

        static class EnumContext {
            @NotNull
            private final List<PsiEnumConstant> myEnumConstants;
            @NotNull
            private final PsiElement myFirst;

            EnumContext(@NotNull List<PsiEnumConstant> enumConstants, @NotNull PsiElement first) {
                this.myEnumConstants = enumConstants;
                this.myFirst = first;
            }
        }
    }

    private static class VarargSortable
    extends Sortable<VarargContext> {
        private VarargSortable() {
        }

        @Override
        boolean isEnd(@NotNull PsiElement element) {
            return element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.RPARENTH;
        }

        @Override
        SortingStrategy @NotNull [] sortStrategies() {
            return Holder.EXPRESSION_SORTING_STRATEGIES;
        }

        @Override
        @Nullable
        VarargContext getContext(@NotNull PsiElement origin) {
            PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)origin, PsiExpressionList.class);
            if (expressionList == null) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiMethodCallExpression.class);
            if (call == null) {
                return null;
            }
            PsiExpression[] arguments = expressionList.getExpressions();
            if (arguments.length < 3) {
                return null;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)call.getMethodExpression().resolve(), PsiMethod.class);
            if (method == null) {
                return null;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            if (arguments.length - parameters2.length + 1 < 3) {
                return null;
            }
            PsiExpression[] varargArguments = VarargSortable.getVarargArguments(arguments, origin, parameters2);
            if (varargArguments == null) {
                return null;
            }
            return new VarargContext(expressionList, Arrays.asList(varargArguments));
        }

        @Override
        @NotNull
        List<PsiElement> getElements(@NotNull VarargContext context) {
            return new ArrayList<PsiElement>(context.myVarargArguments);
        }

        @Override
        PsiElement getFirst(VarargContext context) {
            return (PsiElement)context.myVarargArguments.get(0);
        }

        private static PsiExpression @Nullable [] getVarargArguments(PsiExpression @NotNull [] arguments, @NotNull PsiElement originElement, PsiParameter @NotNull [] parameters2) {
            PsiParameter last = (PsiParameter)ArrayUtil.getLastElement((Object[])parameters2);
            if (last == null) {
                return null;
            }
            if (!last.isVarArgs()) {
                return null;
            }
            PsiExpression closestExpression = VarargSortable.getTopmostExpression(VarargSortable.getClosestExpression(originElement));
            if (closestExpression == null) {
                return null;
            }
            int indexOfCurrent = Arrays.asList(arguments).indexOf(closestExpression);
            if (-1 == indexOfCurrent) {
                return null;
            }
            if (indexOfCurrent < parameters2.length - 1) {
                return null;
            }
            if (arguments.length < parameters2.length + 3 - 1) {
                return null;
            }
            return Arrays.copyOfRange(arguments, parameters2.length - 1, arguments.length);
        }

        @Nullable
        private static PsiExpression getTopmostExpression(@Nullable PsiExpression expression2) {
            PsiExpression parentExpr;
            if (expression2 == null) {
                return null;
            }
            @NotNull PsiExpression current = expression2;
            while ((parentExpr = (PsiExpression)ObjectUtils.tryCast((Object)current.getParent(), PsiExpression.class)) != null) {
                current = parentExpr;
            }
            return current;
        }

        @Nullable
        private static PsiExpression getClosestExpression(@NotNull PsiElement element) {
            while (element != null) {
                if (element instanceof PsiWhiteSpace) {
                    element = element.getNextSibling();
                    continue;
                }
                if (element instanceof PsiJavaToken) {
                    IElementType tokenType = ((PsiJavaToken)element).getTokenType();
                    if (!tokenType.equals(JavaTokenType.COMMA) && !tokenType.equals(TokenType.WHITE_SPACE)) break;
                    element = element.getNextSibling();
                    continue;
                }
                if (!(element instanceof PsiComment)) break;
                element = element.getNextSibling();
            }
            return (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class, (boolean)false);
        }

        @Override
        void replaceWithSorted(PsiElement origin) {
            VarargContext context = this.getContext(origin);
            if (context == null) {
                return;
            }
            SortableList sortableList = this.readEntries(context);
            if (sortableList == null) {
                return;
            }
            sortableList.sort();
            PsiExpressionList expressionList = context.myExpressionList;
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            String methodName = call.getMethodExpression().getText();
            if (methodName == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (PsiElement child : call.getChildren()) {
                if (child == expressionList) break;
                sb.append(child.getText());
            }
            PsiExpression firstVararg = (PsiExpression)context.myVarargArguments.get(0);
            for (PsiElement child = expressionList.getFirstChild(); child != firstVararg; child = child.getNextSibling()) {
                sb.append(child.getText());
            }
            boolean newLineRequired = sortableList.generate(sb);
            if (newLineRequired) {
                sb.append("\n");
            }
            sb.append(")");
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)origin.getProject());
            call.replace((PsiElement)factory.createExpressionFromText(sb.toString(), (PsiElement)call));
        }

        static class VarargContext {
            @NotNull
            private final PsiExpressionList myExpressionList;
            @NotNull
            private final List<PsiExpression> myVarargArguments;

            VarargContext(@NotNull PsiExpressionList expressionList, @NotNull List<PsiExpression> varargArguments) {
                this.myExpressionList = expressionList;
                this.myVarargArguments = varargArguments;
            }
        }
    }

    private static class AnnotationArraySortable
    extends Sortable<PsiArrayInitializerMemberValue> {
        private AnnotationArraySortable() {
        }

        @Override
        boolean isEnd(@NotNull PsiElement element) {
            return element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.RBRACE;
        }

        @Override
        SortingStrategy @NotNull [] sortStrategies() {
            return Holder.EXPRESSION_SORTING_STRATEGIES;
        }

        @Override
        @Nullable
        PsiArrayInitializerMemberValue getContext(@NotNull PsiElement origin) {
            return (PsiArrayInitializerMemberValue)PsiTreeUtil.getParentOfType((PsiElement)origin, PsiArrayInitializerMemberValue.class);
        }

        @Override
        @NotNull
        List<PsiElement> getElements(@NotNull PsiArrayInitializerMemberValue context) {
            return Arrays.asList(context.getInitializers());
        }

        @Override
        PsiElement getFirst(PsiArrayInitializerMemberValue context) {
            return context.getFirstChild();
        }

        @Override
        void replaceWithSorted(PsiElement origin) {
            PsiArrayInitializerMemberValue context = this.getContext(origin);
            if (context == null) {
                return;
            }
            SortableList sortableList = this.readEntries(context);
            if (sortableList == null) {
                return;
            }
            sortableList.sort();
            String replacement = this.generateReplacementText(sortableList);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)origin.getProject());
            PsiAnnotation annotation = factory.createAnnotationFromText("@Ann(" + replacement + ")", null);
            PsiAnnotationMemberValue replacementElement = annotation.getParameterList().getAttributes()[0].getValue();
            assert (replacementElement != null);
            context.replace((PsiElement)replacementElement);
        }

        String generateReplacementText(@NotNull SortableList list) {
            StringBuilder sb = new StringBuilder();
            boolean newLineRequired = list.generate(sb);
            if (newLineRequired) {
                sb.append("\n");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private static class ArrayInitializerSortable
    extends ElementBasedSortable<PsiArrayInitializerExpression> {
        private ArrayInitializerSortable() {
        }

        @Override
        boolean isEnd(@NotNull PsiElement element) {
            return element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.RBRACE;
        }

        @Override
        SortingStrategy @NotNull [] sortStrategies() {
            return Holder.EXPRESSION_SORTING_STRATEGIES;
        }

        @Override
        String generateReplacementText(@NotNull SortableList list, @NotNull PsiArrayInitializerExpression elementToSort) {
            StringBuilder sb = new StringBuilder();
            boolean eolRequired = list.generate(sb);
            if (eolRequired) {
                sb.append("\n");
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        @Nullable
        PsiArrayInitializerExpression getElementToSort(@NotNull PsiElement origin) {
            return (PsiArrayInitializerExpression)PsiTreeUtil.getParentOfType((PsiElement)origin, PsiArrayInitializerExpression.class);
        }

        @Override
        List<PsiElement> getElements(@NotNull PsiArrayInitializerExpression elementToSort) {
            return Arrays.asList(elementToSort.getInitializers());
        }
    }

    static abstract class ElementBasedSortable<T extends PsiElement>
    extends Sortable<ElementContext<T>> {
        ElementBasedSortable() {
        }

        abstract String generateReplacementText(@NotNull SortableList var1, T var2);

        @Override
        void replaceWithSorted(PsiElement origin) {
            Object context = this.getContext(origin);
            if (context == null) {
                return;
            }
            SortableList sortableList = this.readEntries(context);
            if (sortableList == null) {
                return;
            }
            sortableList.sort();
            PsiElement contextElement = ((ElementContext)context).myElement;
            String replacement = this.generateReplacementText(sortableList, contextElement);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)origin.getProject());
            contextElement.replace((PsiElement)factory.createExpressionFromText(replacement, contextElement));
        }

        @Override
        @NotNull
        List<PsiElement> getElements(@NotNull ElementContext<T> context) {
            return this.getElements((T)((ElementContext)context).myElement);
        }

        @Override
        abstract List<PsiElement> getElements(@NotNull T var1);

        @Nullable
        abstract T getElementToSort(@NotNull PsiElement var1);

        @Override
        @Nullable
        ElementContext<T> getContext(@NotNull PsiElement origin) {
            T elementToSort = this.getElementToSort(origin);
            if (elementToSort == null) {
                return null;
            }
            return new ElementContext<T>(elementToSort);
        }

        @Override
        PsiElement getFirst(ElementContext<T> context) {
            return ((ElementContext)context).myElement.getFirstChild();
        }

        static class ElementContext<T extends PsiElement> {
            @NotNull
            private final T myElement;

            ElementContext(@NotNull T element) {
                this.myElement = element;
            }
        }
    }

    private static class LineLayout {
        private final TIntArrayList myEntryCountOnLines = new TIntArrayList();
        private int myCurrent = 0;

        LineLayout() {
            this.myEntryCountOnLines.add(0);
        }

        void addBreaks(int count) {
            for (int i = 0; i < count; ++i) {
                this.myEntryCountOnLines.add(0);
            }
            this.myCurrent += count;
        }

        void addElementOnLine() {
            this.myEntryCountOnLines.set(this.myCurrent, this.myEntryCountOnLines.get(this.myCurrent) + 1);
        }

        private boolean generate(StringBuilder sb, List<? extends SortableEntry> entries) {
            int entryIndex = 0;
            int lines = this.myEntryCountOnLines.size();
            int currentEntryIndex = 0;
            int entryCount = entries.size();
            boolean eolRequired = false;
            for (int rowIndex = 0; rowIndex < lines; ++rowIndex) {
                int entryCountOnRow = this.myEntryCountOnLines.get(rowIndex);
                if (entryCountOnRow == 0) {
                    sb.append("\n");
                    eolRequired = false;
                    continue;
                }
                for (int rowPosition = 0; rowPosition < entryCountOnRow; ++rowPosition) {
                    boolean isLastInRow = rowPosition + 1 == entryCountOnRow && rowIndex + 1 != lines;
                    boolean isLastInList = ++currentEntryIndex == entryCount;
                    eolRequired = entries.get(entryIndex).generate(sb, isLastInList);
                    if (!isLastInList && (isLastInRow || eolRequired)) {
                        sb.append("\n");
                        eolRequired = false;
                    }
                    ++entryIndex;
                }
            }
            return eolRequired;
        }
    }

    private static abstract class Sortable<C> {
        private Sortable() {
        }

        abstract boolean isEnd(@NotNull PsiElement var1);

        abstract SortingStrategy @NotNull [] sortStrategies();

        @Nullable
        abstract C getContext(@NotNull PsiElement var1);

        @NotNull
        abstract List<PsiElement> getElements(@NotNull C var1);

        abstract PsiElement getFirst(C var1);

        abstract void replaceWithSorted(PsiElement var1);

        @Nullable
        SortableList readEntries(@NotNull C context) {
            PsiElement current;
            SortingStrategy strategy = null;
            SmartList beforeFirst = new SmartList();
            block0: for (current = this.getFirst(context); current != null && !this.isEnd(current); current = current.getNextSibling()) {
                for (SortingStrategy currentStrategy : this.sortStrategies()) {
                    if (!currentStrategy.isSuitableEntryElement(current)) continue;
                    strategy = currentStrategy;
                    break block0;
                }
                beforeFirst.add(current);
            }
            if (strategy == null) {
                return null;
            }
            ReadStateMachine sm = new ReadStateMachine(current, strategy, this);
            if (sm.run()) {
                return null;
            }
            List entries = sm.mySortableEntries;
            List entryElements = ContainerUtil.map((Collection)entries, e -> ((SortableEntry)e).myElement);
            if (entryElements.size() < 3) {
                return null;
            }
            if (!strategy.isSuitableElements(entryElements)) {
                return null;
            }
            SortableEntry last = (SortableEntry)entries.get(entries.size() - 1);
            if (last.myElement.getNextSibling() instanceof PsiErrorElement) {
                last.myAfterSeparator.clear();
            }
            return new SortableList(entries, strategy, sm.myLineLayout, (List)beforeFirst);
        }

        boolean isAvailable(@NotNull PsiElement origin) {
            C context = this.getContext(origin);
            if (context == null) {
                return false;
            }
            List<PsiElement> elements = this.getElements(context);
            if (elements.size() < 3) {
                return false;
            }
            SortingStrategy sortingStrategy = this.findSortingStrategy(elements);
            if (sortingStrategy == null) {
                return false;
            }
            Comparator<PsiElement> comparator = sortingStrategy.getComparator();
            return sortingStrategy.isSuitableElements(elements) && !Comparators.isInOrder(elements, comparator);
        }

        @Nullable
        private SortingStrategy findSortingStrategy(List<? extends PsiElement> elements) {
            return Arrays.stream(this.sortStrategies()).filter(strategy -> elements.stream().allMatch(strategy::isSuitableEntryElement)).findFirst().orElse(null);
        }

        boolean isSeparator(@NotNull PsiElement element) {
            return element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.COMMA;
        }

        boolean isError(@NotNull PsiElement element) {
            return element instanceof PsiErrorElement;
        }

        private static class ReadStateMachine {
            @NotNull
            private State myState = State.Element;
            @NotNull
            private PsiElement myCurrent;
            @NotNull
            private final SortingStrategy myStrategy;
            @NotNull
            private final List<SortableEntry> mySortableEntries = new ArrayList<SortableEntry>();
            @NotNull
            private final LineLayout myLineLayout = new LineLayout();
            @NotNull
            private final Sortable<?> mySortable;
            private List<PsiComment> myBeforeSeparator = new SmartList();
            private List<PsiComment> myAfterSeparator = new SmartList();
            private PsiElement myEntryElement = null;
            private boolean myHasErrors = false;

            ReadStateMachine(@NotNull PsiElement current, @NotNull SortingStrategy strategy, @NotNull Sortable<?> block) {
                this.myCurrent = current;
                this.myStrategy = strategy;
                this.mySortable = block;
            }

            boolean run() {
                do {
                    if (this.nextState()) continue;
                    if (this.myEntryElement != null) {
                        this.finishEntry();
                    }
                    return this.myHasErrors;
                } while (!this.myHasErrors);
                return true;
            }

            boolean nextState() {
                boolean isEnd;
                PsiElement next = this.myCurrent.getNextSibling();
                boolean bl = isEnd = next == null || this.mySortable.isEnd(next);
                if (isEnd) {
                    if (this.myState == State.Element) {
                        this.myLineLayout.addElementOnLine();
                        this.myEntryElement = this.myCurrent;
                    }
                    return false;
                }
                boolean isSeparator = this.mySortable.isSeparator(next) || (this.myState == State.Element || this.myState == State.BetweenElementAndSeparator) && this.mySortable.isError(next);
                switch (this.myState) {
                    case Element: {
                        this.myEntryElement = this.myCurrent;
                        this.myLineLayout.addElementOnLine();
                        if (isSeparator) {
                            this.advance(next, State.Separator);
                            break;
                        }
                        this.addIntermediateEntryElement(next, this.myBeforeSeparator);
                        this.advance(next, State.BetweenElementAndSeparator);
                        break;
                    }
                    case BetweenElementAndSeparator: {
                        if (isSeparator) {
                            this.advance(next, State.Separator);
                            break;
                        }
                        this.addIntermediateEntryElement(next, this.myBeforeSeparator);
                        this.advance(next, State.BetweenElementAndSeparator);
                        break;
                    }
                    case Separator: 
                    case AfterSeparator: {
                        if (this.myStrategy.isSuitableEntryElement(next)) {
                            this.finishEntry();
                            this.advance(next, State.Element);
                            break;
                        }
                        this.addIntermediateEntryElement(next, this.myAfterSeparator);
                        this.advance(next, State.AfterSeparator);
                    }
                }
                return true;
            }

            private void finishEntry() {
                if (this.myEntryElement == null) {
                    this.myHasErrors = true;
                    return;
                }
                this.mySortableEntries.add(new SortableEntry(this.myEntryElement, this.myBeforeSeparator, this.myAfterSeparator));
                this.myBeforeSeparator = new SmartList();
                this.myAfterSeparator = new SmartList();
                this.myEntryElement = null;
            }

            private void addIntermediateEntryElement(@NotNull PsiElement element, List<? super PsiComment> target) {
                if (element instanceof PsiWhiteSpace) {
                    int newLineCount = (int)element.getText().chars().filter(value2 -> value2 == 10).count();
                    if (newLineCount != 0) {
                        this.myLineLayout.addBreaks(newLineCount);
                    }
                    return;
                }
                if (element instanceof PsiComment) {
                    target.add((PsiComment)((PsiComment)element));
                }
            }

            private void advance(@NotNull PsiElement next, State state) {
                this.myState = state;
                this.myCurrent = next;
            }
        }

        private static enum State {
            Element,
            BetweenElementAndSeparator,
            Separator,
            AfterSeparator;

        }
    }

    private static class SortableList {
        private final List<SortableEntry> myEntries;
        private final SortingStrategy mySortingStrategy;
        private final LineLayout myLineLayout;
        private final List<? extends PsiElement> myBeforeFirstElements;

        private SortableList(List<SortableEntry> entries, SortingStrategy strategy, LineLayout layout, List<? extends PsiElement> beforeFirstElements) {
            this.myEntries = entries;
            this.mySortingStrategy = strategy;
            this.myLineLayout = layout;
            this.myBeforeFirstElements = beforeFirstElements;
        }

        boolean generate(StringBuilder sb) {
            for (PsiElement psiElement : this.myBeforeFirstElements) {
                sb.append(psiElement.getText());
            }
            return this.myLineLayout.generate(sb, this.myEntries);
        }

        void sort() {
            Comparator<PsiElement> comparator = this.mySortingStrategy.getComparator();
            this.myEntries.sort(Comparator.comparing(sortableEntry -> ((SortableEntry)sortableEntry).myElement, comparator));
        }

        PsiElement getLastElement() {
            SortableEntry last = this.myEntries.get(this.myEntries.size() - 1);
            List beforeSeparator = last.myBeforeSeparator;
            if (beforeSeparator.isEmpty()) {
                return last.myElement;
            }
            return (PsiElement)beforeSeparator.get(beforeSeparator.size() - 1);
        }
    }

    private static class SortableEntry {
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final List<PsiComment> myBeforeSeparator;
        @NotNull
        private final List<? extends PsiComment> myAfterSeparator;

        private SortableEntry(@NotNull PsiElement element, @NotNull List<PsiComment> beforeSeparator, @NotNull List<? extends PsiComment> afterSeparator) {
            this.myElement = element;
            this.myBeforeSeparator = beforeSeparator;
            this.myAfterSeparator = afterSeparator;
        }

        boolean generate(StringBuilder sb, boolean isLastInList) {
            sb.append(this.myElement.getText());
            boolean newLineNeed = SortableEntry.generateComments(sb, this.myBeforeSeparator);
            if (newLineNeed) {
                if (isLastInList && this.myAfterSeparator.isEmpty()) {
                    return true;
                }
                sb.append("\n");
            }
            if (!isLastInList) {
                sb.append(",");
            }
            return SortableEntry.generateComments(sb, this.myAfterSeparator);
        }

        private static boolean generateComments(StringBuilder sb, List<? extends PsiComment> comments) {
            boolean newLineNeed = false;
            for (PsiComment psiComment : comments) {
                if (newLineNeed) {
                    sb.append('\n');
                    newLineNeed = false;
                }
                sb.append(" ");
                sb.append(psiComment.getText());
                if (psiComment.getTokenType() != JavaTokenType.END_OF_LINE_COMMENT) continue;
                newLineNeed = true;
            }
            return newLineNeed;
        }
    }

    private static class EnumConstantDeclarationSortingStrategy
    implements SortingStrategy {
        private EnumConstantDeclarationSortingStrategy() {
        }

        @Override
        public boolean isSuitableEntryElement(@NotNull PsiElement element) {
            return element instanceof PsiEnumConstant;
        }

        @Override
        @NotNull
        public Comparator<PsiElement> getComparator() {
            return Comparator.comparing(el -> ((PsiEnumConstant)el).getName());
        }

        @Override
        public boolean isSuitableElements(List<? extends PsiElement> elements) {
            Set names2 = elements.stream().map(element -> ((PsiEnumConstant)element).getName()).collect(Collectors.toSet());
            for (PsiElement psiElement : elements) {
                PsiEnumConstant enumConstant = (PsiEnumConstant)psiElement;
                if (!StreamEx.ofTree((Object)enumConstant.getArgumentList(), el -> StreamEx.of((Object[])el.getChildren())).select(PsiReferenceExpression.class).map(ref -> ref.getReferenceName()).anyMatch(refName -> names2.contains(refName))) continue;
                return false;
            }
            return true;
        }
    }

    private static class EnumConstantSortingStrategy
    implements SortingStrategy {
        private EnumConstantSortingStrategy() {
        }

        private static PsiType extractType(@NotNull PsiElement element) {
            PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)element, PsiExpression.class);
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiReferenceExpression.class);
            if (referenceExpression == null) {
                return null;
            }
            PsiEnumConstant enumConstant = (PsiEnumConstant)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiEnumConstant.class);
            if (enumConstant == null) {
                return null;
            }
            return referenceExpression.getType();
        }

        @Override
        public boolean isSuitableEntryElement(@NotNull PsiElement element) {
            return EnumConstantSortingStrategy.extractType(element) != null;
        }

        @Override
        @NotNull
        public Comparator<PsiElement> getComparator() {
            return Comparator.comparing(el -> {
                PsiExpression expr2 = (PsiExpression)el;
                return ((PsiReferenceExpression)Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)expr2))).getReferenceName();
            });
        }

        @Override
        public boolean isSuitableElements(@NotNull List<? extends PsiElement> elements) {
            PsiElement first = elements.get(0);
            PsiType firstType = EnumConstantSortingStrategy.extractType(first);
            if (firstType == null) {
                return false;
            }
            return elements.stream().map(element -> (PsiExpression)element).allMatch(expr2 -> firstType.equals(expr2.getType()));
        }
    }

    private static class IntLiteralSortingStrategy
    implements SortingStrategy {
        private IntLiteralSortingStrategy() {
        }

        @Override
        public boolean isSuitableEntryElement(@NotNull PsiElement element) {
            PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)element, PsiExpression.class);
            if (expression2 == null) {
                return false;
            }
            return ExpressionUtils.computeConstantExpression(expression2) instanceof Integer;
        }

        @Override
        @NotNull
        public Comparator<PsiElement> getComparator() {
            return Comparator.comparing(element -> (Integer)ExpressionUtils.computeConstantExpression((PsiExpression)element));
        }
    }

    private static class StringLiteralSortingStrategy
    implements SortingStrategy {
        private StringLiteralSortingStrategy() {
        }

        @Override
        public boolean isSuitableEntryElement(@NotNull PsiElement element) {
            PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)element, PsiExpression.class);
            if (expression2 == null) {
                return false;
            }
            return ExpressionUtils.computeConstantExpression(expression2) instanceof String;
        }

        @Override
        @NotNull
        public Comparator<PsiElement> getComparator() {
            return Comparator.comparing(element -> (String)ExpressionUtils.computeConstantExpression((PsiExpression)element));
        }
    }

    private static interface SortingStrategy {
        public boolean isSuitableEntryElement(@NotNull PsiElement var1);

        @NotNull
        public Comparator<PsiElement> getComparator();

        default public boolean isSuitableElements(List<? extends PsiElement> elements) {
            return true;
        }
    }

    private static class Holder {
        public static final SortingStrategy[] EXPRESSION_SORTING_STRATEGIES = new SortingStrategy[]{new StringLiteralSortingStrategy(), new IntLiteralSortingStrategy(), new EnumConstantSortingStrategy()};
        private static final Sortable<?>[] OUR_SORTABLES = new Sortable[]{new ArrayInitializerSortable(), new VarargSortable(), new EnumConstantDeclarationSortable(), new AnnotationArraySortable()};

        private Holder() {
        }
    }
}

