/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.BaseMoveInitializerToMethodAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MoveInitializerToConstructorAction
extends BaseMoveInitializerToMethodAction {
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return JavaBundle.message((String)"intention.move.initializer.to.constructor", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (super.isAvailable(project, editor, element)) {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
            assert (field != null);
            if (field.hasModifierProperty("final")) {
                PsiClass containingClass = field.getContainingClass();
                assert (containingClass != null);
                Object[] initializers = containingClass.getInitializers();
                Object[] elements = (PsiElement[])Arrays.stream(containingClass.getFields()).map(f -> f.getInitializer()).filter(Objects::nonNull).toArray(PsiElement[]::new);
                return ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement[])ArrayUtil.mergeArrays((Object[])elements, (Object[])initializers))).findFirst() == null;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected Collection<String> getUnsuitableModifiers() {
        return Collections.singletonList("static");
    }

    @Override
    @NotNull
    protected Collection<PsiMethod> getOrCreateMethods(@NotNull Project project, @NotNull Editor editor, PsiFile file, @NotNull PsiClass aClass) {
        List<PsiMethod> constructors = Arrays.asList(aClass.getConstructors());
        if (constructors.isEmpty()) {
            return MoveInitializerToConstructorAction.createConstructor(project, editor, file, aClass);
        }
        return MoveInitializerToConstructorAction.removeChainedConstructors(constructors);
    }

    @NotNull
    private static Collection<PsiMethod> removeChainedConstructors(@NotNull Collection<? extends PsiMethod> constructors) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(constructors);
        result.removeIf(constructor -> !JavaHighlightUtil.getChainedConstructors(constructor).isEmpty());
        return result;
    }

    @NotNull
    private static Collection<PsiMethod> createConstructor(@NotNull Project project, @NotNull Editor editor, PsiFile file, @NotNull PsiClass aClass) {
        LocalQuickFixAndIntentionActionOnPsiElement addDefaultConstructorFix = QuickFixFactory.getInstance().createAddDefaultConstructorFix(aClass);
        int offset = editor.getCaretModel().getOffset();
        addDefaultConstructorFix.invoke(project, editor, file);
        editor.getCaretModel().moveToOffset(offset);
        return Arrays.asList(aClass.getConstructors());
    }
}

