/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeannotateIntentionAction
implements IntentionAction,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(DeannotateIntentionAction.class);
    private String myAnnotationName;

    @NotNull
    public String getText() {
        return JavaBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]) + (this.myAnnotationName != null ? " @" + this.myAnnotationName : "...");
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"deannotate.intention.action.text", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        ExternalAnnotationsManager externalAnnotationsManager;
        PsiAnnotation[] annotations;
        this.myAnnotationName = null;
        PsiModifierListOwner listOwner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset(), true);
        if (listOwner != null && (annotations = (externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project)).findExternalAnnotations(listOwner)) != null && annotations.length > 0) {
            List files;
            if (annotations.length == 1) {
                this.myAnnotationName = annotations[0].getQualifiedName();
            }
            if ((files = externalAnnotationsManager.findExternalAnnotationsFiles(listOwner)) == null || files.isEmpty()) {
                return false;
            }
            VirtualFile virtualFile = ((PsiFile)files.get(0)).getVirtualFile();
            return virtualFile != null && (virtualFile.isWritable() || virtualFile.isInLocalFileSystem());
        }
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        final PsiModifierListOwner listOwner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset(), true);
        LOG.assertTrue(listOwner != null);
        final ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        PsiAnnotation[] externalAnnotations = annotationsManager.findExternalAnnotations(listOwner);
        LOG.assertTrue(externalAnnotations != null && externalAnnotations.length > 0);
        if (externalAnnotations.length == 1) {
            this.deannotate(externalAnnotations[0], project, file, annotationsManager, listOwner);
            return;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PsiAnnotation>(JavaBundle.message((String)"deannotate.intention.chooser.title", (Object[])new Object[0]), externalAnnotations){

            public PopupStep<?> onChosen(PsiAnnotation selectedValue, boolean finalChoice) {
                if (finalChoice) {
                    this.doFinalStep(() -> DeannotateIntentionAction.this.deannotate(selectedValue, project, file, annotationsManager, listOwner));
                }
                return PopupStep.FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(PsiAnnotation value2) {
                String qualifiedName = value2.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                return qualifiedName;
            }
        }).showInBestPositionFor(editor);
    }

    private void deannotate(PsiAnnotation annotation, Project project, PsiFile file, ExternalAnnotationsManager annotationsManager, PsiModifierListOwner listOwner) {
        VirtualFile virtualFile = file.getVirtualFile();
        String qualifiedName = annotation.getQualifiedName();
        LOG.assertTrue(qualifiedName != null);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (annotationsManager.deannotate(listOwner, qualifiedName) && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                UndoUtil.markPsiFileForUndo((PsiFile)file);
            }
        }, this.getText(), null);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

