/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterActionBase;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CreateFieldFromParameterAction
extends CreateFieldFromParameterActionBase {
    private final boolean myIsFix;

    public CreateFieldFromParameterAction() {
        this(false);
    }

    public CreateFieldFromParameterAction(boolean isFix) {
        this.myIsFix = isFix;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiParameter parameter2) {
        PsiClass targetClass;
        PsiElement scope = parameter2.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        boolean isConstructor = ((PsiMethod)scope).isConstructor();
        if (this.myIsFix && !isConstructor) {
            return false;
        }
        PsiCodeBlock body2 = ((PsiMethod)scope).getBody();
        if (body2 == null) {
            return false;
        }
        if (!this.myIsFix && isConstructor && ReferencesSearch.search((PsiElement)parameter2, (SearchScope)new LocalSearchScope((PsiElement)body2)).findFirst() == null) {
            return false;
        }
        PsiType type2 = this.getSubstitutedType(parameter2);
        return FieldFromParameterUtils.isAvailable(parameter2, type2, targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameter2, PsiClass.class), false) && parameter2.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @Override
    protected PsiType getSubstitutedType(@NotNull PsiParameter parameter2) {
        return FieldFromParameterUtils.getSubstitutedType(parameter2);
    }

    @Override
    protected void performRefactoring(@NotNull Project project, @NotNull PsiClass targetClass, @NotNull PsiMethod method, @NotNull PsiParameter myParameter, PsiType type2, @NotNull String fieldName, boolean methodStatic, boolean isFinal) {
        FieldFromParameterUtils.createFieldAndAddAssignment(project, targetClass, method, myParameter, type2, fieldName, methodStatic, isFinal);
    }
}

