/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapseAnnotationsFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private CollapseAnnotationsFix(PsiAnnotation annotation) {
        super((PsiElement)annotation);
    }

    @NotNull
    public String getText() {
        return JavaBundle.message((String)"intention.text.collapse.repeating.annotations", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (!(startElement instanceof PsiAnnotation)) {
            return;
        }
        PsiAnnotation annotation = (PsiAnnotation)startElement;
        PsiNameValuePair attribute = (PsiNameValuePair)ArrayUtil.getFirstElement((Object[])annotation.getParameterList().getAttributes());
        if (attribute == null) {
            return;
        }
        PsiAnnotationMemberValue origValue = attribute.getValue();
        if (origValue == null) {
            return;
        }
        List<PsiAnnotation> annotations = CollapseAnnotationsFix.findCollapsibleAnnotations(annotation, attribute);
        ArrayList<PsiAnnotationMemberValue> values = new ArrayList<PsiAnnotationMemberValue>();
        CommentTracker ct = new CommentTracker();
        for (PsiAnnotation anno : annotations) {
            PsiAnnotationMemberValue value2 = anno.getParameterList().getAttributes()[0].getValue();
            if (value2 instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                    values.add(ct.markUnchanged(initializer));
                }
            } else if (value2 != null) {
                values.add(ct.markUnchanged(value2));
            }
            if (anno == annotation) continue;
            ct.delete((PsiElement)anno);
        }
        String newValue = StreamEx.of(values).map(PsiElement::getText).joining((CharSequence)", ", (CharSequence)"{", (CharSequence)"}");
        PsiAnnotation dummy = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@x(" + newValue + ")", (PsiElement)origValue);
        ct.replaceAndRestoreComments((PsiElement)origValue, (PsiElement)Objects.requireNonNull(dummy.getParameterList().getAttributes()[0].getValue()));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    private static List<PsiAnnotation> findCollapsibleAnnotations(PsiAnnotation annotation, PsiNameValuePair attribute) {
        PsiAnnotationOwner owner2 = annotation.getOwner();
        String name2 = annotation.getQualifiedName();
        if (owner2 == null || name2 == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiAnnotation> annotations = new ArrayList<PsiAnnotation>();
        for (PsiAnnotation other : owner2.getAnnotations()) {
            PsiNameValuePair otherAttribute;
            PsiNameValuePair[] otherAttributes;
            if (!name2.equals(other.getQualifiedName()) || (otherAttributes = other.getParameterList().getAttributes()).length != 1 || !(otherAttribute = otherAttributes[0]).getAttributeName().equals(attribute.getAttributeName())) continue;
            annotations.add(other);
        }
        return annotations;
    }

    @Nullable
    public static CollapseAnnotationsFix from(PsiAnnotation annotation) {
        PsiAnnotationOwner owner2 = annotation.getOwner();
        String name2 = annotation.getQualifiedName();
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (owner2 == null || name2 == null || attributes.length != 1) {
            return null;
        }
        PsiNameValuePair attribute = attributes[0];
        if (attribute.getValue() == null) {
            return null;
        }
        PsiMethod annoMethod = CollapseAnnotationsFix.findAttributeMethod(attribute);
        if (annoMethod == null || !(annoMethod.getReturnType() instanceof PsiArrayType)) {
            return null;
        }
        List<PsiAnnotation> annotations = CollapseAnnotationsFix.findCollapsibleAnnotations(annotation, attribute);
        if (annotations.size() < 2) {
            return null;
        }
        return new CollapseAnnotationsFix(annotation);
    }

    @Nullable
    private static PsiMethod findAttributeMethod(PsiNameValuePair attribute) {
        PsiReference ref = attribute.getReference();
        if (ref == null) {
            return null;
        }
        PsiElement target = ref.resolve();
        if (PsiUtil.isAnnotationMethod((PsiElement)target)) {
            return (PsiAnnotationMethod)target;
        }
        return null;
    }
}

