/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BreakStringOnLineBreaksIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.STRING_LITERAL) {
            return false;
        }
        String text2 = token.getText();
        if (text2 == null) {
            return false;
        }
        int indexOfSlashN = text2.indexOf("\\n");
        if (indexOfSlashN == -1 || Objects.equals(text2.substring(indexOfSlashN), "\\n\"")) {
            return false;
        }
        int indexOfSlashNSlashR = text2.indexOf("\\n\\r");
        return indexOfSlashNSlashR == -1 || !Objects.equals(text2.substring(indexOfSlashNSlashR), "\\n\\r\"");
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.STRING_LITERAL) {
            return;
        }
        String text2 = token.getText();
        if (text2 == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        token.getParent().replace((PsiElement)factory.createExpressionFromText(BreakStringOnLineBreaksIntentionAction.breakOnLineBreaks(text2), element));
    }

    @NotNull
    private static String breakOnLineBreaks(@NotNull String string) {
        String result = StringUtil.replace((String)string, Arrays.asList("\\n\\r", "\\n"), Arrays.asList("\\n\\r\" + \n\"", "\\n\" + \n\""));
        String redundantSuffix = " + \n\"\"";
        return result.endsWith(" + \n\"\"") ? result.substring(0, result.length() - " + \n\"\"".length()) : result;
    }

    @NotNull
    public String getText() {
        return JavaBundle.message((String)"intention.break.string.on.line.breaks.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }
}

