/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.externalAnnotation.AnnotationProvider;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AnnotateIntentionAction
extends BaseIntentionAction
implements LowPriorityAction {
    private String mySingleAnnotationName;

    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
    }

    private static StreamEx<AnnotationProvider> availableAnnotations(PsiModifierListOwner owner2, Project project) {
        return (StreamEx)((StreamEx)StreamEx.of((Collection)AnnotationProvider.KEY.getExtensionList()).filter(p -> p.isAvailable(owner2))).filter(p -> !AnnotateIntentionAction.alreadyAnnotated(owner2, p, project));
    }

    public boolean selectSingle(Editor editor, PsiFile file, String annotationShortName) {
        if (this.mySingleAnnotationName != null) {
            throw new IllegalStateException();
        }
        this.mySingleAnnotationName = annotationShortName;
        PsiModifierListOwner owner2 = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        if (owner2 == null || owner2.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner2)) {
            return false;
        }
        return AnnotateIntentionAction.canAnnotateWith(file, owner2, annotationShortName);
    }

    private static boolean canAnnotateWith(PsiFile file, PsiModifierListOwner owner2, String annotationShortName) {
        return AnnotateIntentionAction.getProviderFor(file, owner2, annotationShortName).isPresent();
    }

    private static Optional<AnnotationProvider> getProviderFor(PsiFile file, PsiModifierListOwner owner2, String annotationShortName) {
        return (Optional)((StreamEx)AnnotateIntentionAction.availableAnnotations(owner2, file.getProject()).filter(p -> StringUtil.getShortName((String)p.getName(file.getProject())).equals(annotationShortName))).collect(MoreCollectors.onlyOne());
    }

    private static boolean alreadyAnnotated(PsiModifierListOwner owner2, AnnotationProvider p, Project project) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner2, (String[])((String[])ArrayUtil.prepend((Object)p.getName(owner2.getProject()), (Object[])p.getAnnotationsToRemove(project))));
        return annotation != null && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner owner2 = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        if (owner2 == null || owner2.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner2)) {
            return false;
        }
        List annotations = (List)((StreamEx)AnnotateIntentionAction.availableAnnotations(owner2, project).limit(2L)).collect(Collectors.toList());
        if (annotations.isEmpty()) {
            return false;
        }
        if (this.mySingleAnnotationName != null && AnnotateIntentionAction.canAnnotateWith(file, owner2, this.mySingleAnnotationName)) {
            return true;
        }
        if (annotations.size() == 1) {
            String providerName = ((AnnotationProvider)annotations.get(0)).getName(project);
            this.setText(AddAnnotationPsiFix.calcText(owner2, providerName));
        } else {
            this.setText(AddAnnotationPsiFix.calcText(owner2, null));
        }
        return true;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        final PsiModifierListOwner owner2 = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        assert (owner2 != null);
        if (this.mySingleAnnotationName != null) {
            AnnotateIntentionAction.getProviderFor(file, owner2, this.mySingleAnnotationName).ifPresent(provider -> provider.createFix(owner2).invoke(project, editor, file));
            return;
        }
        List annotations = (List)AnnotateIntentionAction.availableAnnotations(owner2, project).collect(Collectors.toList());
        if (annotations.isEmpty()) {
            return;
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AnnotationProvider>(JavaBundle.message((String)"annotate.intention.chooser.title", (Object[])new Object[0]), annotations){

            public PopupStep onChosen(AnnotationProvider selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> selectedValue.createFix(owner2).invoke(project, editor, file));
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(AnnotationProvider value2) {
                return value2.getName(project);
            }
        }).showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

