/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class AddExplicitTypeArgumentsIntention
extends BaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.add.explicit.type.arguments.family", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiMethodCallExpression callExpression;
        JavaResolveResult result;
        PsiIdentifier identifier = (PsiIdentifier)ObjectUtils.tryCast((Object)element, PsiIdentifier.class);
        if (identifier == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)identifier.getParent(), PsiReferenceExpression.class);
        if (methodExpression == null) {
            return false;
        }
        PsiElement parent = methodExpression.getParent();
        if (parent instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)parent).getTypeArguments().length == 0 && (result = (callExpression = (PsiMethodCallExpression)parent).resolveMethodGenerics()) instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).isApplicable()) {
            PsiElement method = result.getElement();
            this.setText(this.getFamilyName());
            return method instanceof PsiMethod && !((PsiMethod)method).isConstructor() && ((PsiMethod)method).hasTypeParameters() && AddTypeArgumentsFix.addTypeArguments((PsiExpression)callExpression, null) != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        assert (callExpression != null);
        PsiExpression withArgs = AddTypeArgumentsFix.addTypeArguments((PsiExpression)callExpression, null);
        if (withArgs != null) {
            CodeStyleManager.getInstance((Project)project).reformat(callExpression.replace((PsiElement)withArgs));
        }
    }
}

