/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationParameterInfoHandler
implements ParameterInfoHandler<PsiAnnotationParameterList, PsiAnnotationMethod>,
DumbAware {
    public Object @Nullable [] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    public boolean couldShowInLookup() {
        return false;
    }

    public PsiAnnotationParameterList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        Object[] methods;
        PsiClass aClass;
        PsiAnnotation annotation = (PsiAnnotation)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), PsiAnnotation.class);
        if (annotation != null && (aClass = annotation.resolveAnnotationType()) != null && (methods = aClass.getMethods()).length != 0) {
            context.setItemsToShow(methods);
            PsiAnnotationMethod annotationMethod = AnnotationParameterInfoHandler.findAnnotationMethod(context.getFile(), context.getOffset());
            if (annotationMethod != null) {
                context.setHighlightedElement((PsiElement)annotationMethod);
            }
            return annotation.getParameterList();
        }
        return null;
    }

    public void showParameterInfo(@NotNull PsiAnnotationParameterList element, @NotNull CreateParameterInfoContext context) {
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    public PsiAnnotationParameterList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        PsiAnnotation annotation = (PsiAnnotation)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), PsiAnnotation.class);
        return annotation != null ? annotation.getParameterList() : null;
    }

    public void updateParameterInfo(@NotNull PsiAnnotationParameterList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        int offset1;
        CharSequence chars = context.getEditor().getDocument().getCharsSequence();
        char c = chars.charAt(offset1 = CharArrayUtil.shiftForward((CharSequence)chars, (int)context.getEditor().getCaretModel().getOffset(), (String)" \t"));
        if (c == ',' || c == ')') {
            offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset1 - 1), (String)" \t");
        }
        context.setHighlightedParameter((Object)AnnotationParameterInfoHandler.findAnnotationMethod(context.getFile(), offset1));
    }

    public void updateUI(PsiAnnotationMethod p, @NotNull ParameterInfoUIContext context) {
        AnnotationParameterInfoHandler.updateUIText(p, context);
    }

    public static String updateUIText(PsiAnnotationMethod p, ParameterInfoUIContext context) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(p.getReturnType().getPresentableText());
        buffer.append(" ");
        int highlightStartOffset = buffer.length();
        buffer.append(p.getName());
        int highlightEndOffset = buffer.length();
        buffer.append("()");
        if (p.getDefaultValue() != null) {
            buffer.append(" default ");
            buffer.append(p.getDefaultValue().getText());
        }
        return context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, false, p.isDeprecated(), false, context.getDefaultParameterColor());
    }

    private static PsiAnnotationMethod findAnnotationMethod(PsiFile file, int offset) {
        PsiNameValuePair pair2 = (PsiNameValuePair)ParameterInfoUtils.findParentOfType((PsiFile)file, (int)offset, PsiNameValuePair.class);
        if (pair2 == null) {
            return null;
        }
        PsiReference reference = pair2.getReference();
        PsiElement resolved = reference != null ? reference.resolve() : null;
        return PsiUtil.isAnnotationMethod((PsiElement)resolved) ? (PsiAnnotationMethod)resolved : null;
    }
}

