/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.java.JavaBundle;
import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JavaTypeProvider
extends ExpressionTypeProvider<PsiExpression> {
    @NotNull
    public String getInformationHint(@NotNull PsiExpression element) {
        return StringUtil.escapeXmlEntities((String)JavaTypeProvider.getTypePresentation(element));
    }

    @NotNull
    private static String getTypePresentation(@NotNull PsiExpression element) {
        PsiType type2 = element.getType();
        if (type2 instanceof PsiLambdaExpressionType) {
            type2 = ((PsiLambdaExpressionType)type2).getExpression().getFunctionalInterfaceType();
        } else if (type2 instanceof PsiMethodReferenceType) {
            type2 = ((PsiMethodReferenceType)type2).getExpression().getFunctionalInterfaceType();
        }
        return type2 == null ? "<unknown>" : type2.getPresentableText();
    }

    @NotNull
    public String getErrorHint() {
        return JavaBundle.message((String)"error.hint.no.expression.found", (Object[])new Object[0]);
    }

    @NotNull
    public List<PsiExpression> getExpressionsAt(@NotNull PsiElement elementAt) {
        return SyntaxTraverser.psiApi().parents((Object)elementAt).filter(PsiExpression.class).filter(JavaTypeProvider::isLargestNonTrivialExpression).toList();
    }

    private static boolean isLargestNonTrivialExpression(@NotNull PsiExpression e) {
        PsiElement p = e.getParent();
        if (p instanceof PsiUnaryExpression) {
            return false;
        }
        return !(p instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)p).getMethodExpression() != e;
    }

    public boolean hasAdvancedInformation() {
        return true;
    }

    @NotNull
    public String getAdvancedInformationHint(@NotNull PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
            return "<unknown>";
        }
        CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(expression2);
        ArrayList<Pair> infoLines = new ArrayList<Pair>();
        String basicType = JavaTypeProvider.getTypePresentation(expression2);
        if (result != null) {
            DfType dfType = result.getDfType(expression2);
            PsiType type2 = expression2.getType();
            Set<Object> values = result.getExpressionValues(expression2);
            if (!values.isEmpty()) {
                if (values.size() == 1) {
                    infoLines.add(Pair.create((Object)"Value", (Object)DfConstantType.renderValue(values.iterator().next())));
                } else {
                    infoLines.add(Pair.create((Object)"Value (one of)", (Object)((StreamEx)StreamEx.of(values).map(DfConstantType::renderValue).sorted()).joining((CharSequence)", ")));
                }
            } else {
                if (dfType instanceof DfAntiConstantType) {
                    ArrayList nonValues = new ArrayList(((DfAntiConstantType)dfType).getNotValues());
                    nonValues.remove(null);
                    if (!nonValues.isEmpty()) {
                        infoLines.add(Pair.create((Object)"Not equal to", (Object)((StreamEx)StreamEx.of(nonValues).map(DfConstantType::renderValue).sorted()).joining((CharSequence)", ")));
                    }
                }
                if (dfType instanceof DfIntegralType) {
                    String rangeText = ((DfIntegralType)dfType).getRange().getPresentationText(type2);
                    if (!rangeText.equals("any value")) {
                        infoLines.add(Pair.create((Object)"Range", (Object)rangeText));
                    }
                } else if (dfType instanceof DfReferenceType) {
                    DfReferenceType refType = (DfReferenceType)dfType;
                    infoLines.add(Pair.create((Object)"Nullability", (Object)refType.getNullability().getPresentationName()));
                    infoLines.add(Pair.create((Object)"Constraints", (Object)refType.getConstraint().getPresentationText(type2)));
                    if (refType.getMutability() != Mutability.UNKNOWN) {
                        infoLines.add(Pair.create((Object)"Mutability", (Object)refType.getMutability().toString()));
                    }
                    infoLines.add(Pair.create((Object)"Locality", (Object)(refType.isLocal() ? "local object" : "")));
                    SpecialField field = refType.getSpecialField();
                    if (field != null) {
                        infoLines.add(Pair.create((Object)StringUtil.wordsToBeginFromUpperCase((String)field.toString()), (Object)field.getPresentationText(refType.getSpecialFieldType(), type2)));
                    }
                }
            }
        }
        infoLines.removeIf(pair2 -> ((String)pair2.getSecond()).isEmpty());
        if (!infoLines.isEmpty()) {
            infoLines.add(0, Pair.create((Object)"Type", (Object)basicType));
            return StreamEx.of(infoLines).map(pair2 -> JavaTypeProvider.makeHtmlRow((String)pair2.getFirst(), (String)pair2.getSecond())).joining((CharSequence)"", (CharSequence)"<table>", (CharSequence)"</table>");
        }
        return basicType;
    }

    private static String makeHtmlRow(@NotNull String titleText, String contentText) {
        String titleCell = "<td align='left' valign='top' style='color:" + ColorUtil.toHtmlColor((Color)DocumentationComponent.SECTION_COLOR) + "'>" + StringUtil.escapeXmlEntities((String)titleText) + ":</td>";
        String contentCell = "<td>" + StringUtil.escapeXmlEntities((String)contentText) + "</td>";
        return "<tr>" + titleCell + contentCell + "</tr>";
    }
}

