/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionVariableDescriptor
implements VariableDescriptor {
    public static final Hash.Strategy<PsiExpression> EXPRESSION_HASHING_STRATEGY = new PsiExpressionStrategy();
    @NotNull
    private final PsiExpression myExpression;

    public ExpressionVariableDescriptor(@NotNull PsiExpression expression2) {
        this.myExpression = expression2;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @NotNull
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    @Nullable
    public PsiType getType(@Nullable DfaVariableValue qualifier) {
        return this.myExpression.getType();
    }

    public int hashCode() {
        return EXPRESSION_HASHING_STRATEGY.hashCode((Object)this.myExpression);
    }

    public boolean equals(Object obj) {
        return obj instanceof ExpressionVariableDescriptor && EXPRESSION_HASHING_STRATEGY.equals((Object)this.myExpression, (Object)((ExpressionVariableDescriptor)obj).myExpression);
    }

    public String toString() {
        return this.myExpression.getText();
    }

    private static class PsiExpressionStrategy
    implements Hash.Strategy<PsiExpression> {
        private static final Logger LOG = Logger.getInstance(PsiExpressionStrategy.class);

        private PsiExpressionStrategy() {
        }

        public int hashCode(PsiExpression object) {
            if (object == null) {
                return 0;
            }
            if (object instanceof PsiReferenceExpression) {
                return Objects.hashCode(((PsiReferenceExpression)object).getReferenceName()) * 31 + 1;
            }
            if (object instanceof PsiMethodCallExpression) {
                return Objects.hashCode(((PsiMethodCallExpression)object).getMethodExpression().getReferenceName()) * 31 + 2;
            }
            return object.getNode().getElementType().hashCode();
        }

        public boolean equals(PsiExpression o1, PsiExpression o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (JavaPsiEquivalenceUtil.areExpressionsEquivalent(o1, o2)) {
                if (this.hashCode(o1) != this.hashCode(o2)) {
                    LOG.error("different hashCodes: " + o1 + "; " + o2 + "; " + this.hashCode(o1) + "!=" + this.hashCode(o2));
                }
                return true;
            }
            return false;
        }
    }
}

