/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SimpleFieldChooser
extends DialogWrapper {
    private final PsiField[] myFields;
    private JList myList;

    public SimpleFieldChooser(PsiField[] members, Project project) {
        super(project, true);
        this.myFields = members;
        this.init();
    }

    protected JComponent createCenterPanel() {
        DefaultListModel<PsiField> model = new DefaultListModel<PsiField>();
        for (PsiField member : this.myFields) {
            model.addElement(member);
        }
        this.myList = new JBList(model);
        this.myList.setCellRenderer(new MyListCellRenderer());
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (SimpleFieldChooser.this.myList.getSelectedValues().length > 0) {
                    SimpleFieldChooser.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myList);
        this.myList.setPreferredSize((Dimension)JBUI.size((int)300, (int)400));
        return this.myList;
    }

    public Object[] getSelectedElements() {
        return this.myList.getSelectedValues();
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value2, index, isSelected, cellHasFocus);
            Icon icon = null;
            if (value2 instanceof PsiField) {
                PsiField field = (PsiField)value2;
                icon = field.getIcon(0);
                String text2 = PsiFormatUtil.formatVariable((PsiVariable)field, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                this.setText(text2);
            }
            super.setIcon(icon);
            return this;
        }
    }
}

