/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.ui;

import com.intellij.codeInsight.generation.EqualsHashCodeTemplatesManager;
import com.intellij.codeInsight.generation.GenerateEqualsHelper;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.NamedItemsListEditor;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.JBUI;
import gnu.trove.Equality;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.view.GenerateTemplateConfigurable;

public class EqualsHashCodeTemplatesPanel
extends NamedItemsListEditor<Couple<TemplateResource>> {
    private static final Namer<Couple<TemplateResource>> NAMER = new Namer<Couple<TemplateResource>>(){

        public String getName(Couple<TemplateResource> couple) {
            return EqualsHashCodeTemplatesManager.getTemplateBaseName((TemplateResource)couple.first);
        }

        public boolean canRename(Couple<TemplateResource> item) {
            return !((TemplateResource)item.first).isDefault();
        }

        public void setName(Couple<TemplateResource> couple, String name2) {
            ((TemplateResource)couple.first).setFileName(EqualsHashCodeTemplatesManager.toEqualsName(name2));
            ((TemplateResource)couple.second).setFileName(EqualsHashCodeTemplatesManager.toHashCodeName(name2));
        }
    };
    private static final Factory<Couple<TemplateResource>> FACTORY = () -> Couple.of((Object)new TemplateResource(), (Object)new TemplateResource());
    private static final Cloner<Couple<TemplateResource>> CLONER = new Cloner<Couple<TemplateResource>>(){

        public Couple<TemplateResource> cloneOf(Couple<TemplateResource> couple) {
            if (((TemplateResource)couple.first).isDefault()) {
                return couple;
            }
            return this.copyOf(couple);
        }

        public Couple<TemplateResource> copyOf(Couple<TemplateResource> couple) {
            return Couple.of((Object)this.copyOf((TemplateResource)couple.first), (Object)this.copyOf((TemplateResource)couple.second));
        }

        @NotNull
        private TemplateResource copyOf(TemplateResource resource) {
            TemplateResource result = new TemplateResource();
            result.setFileName(resource.getFileName());
            result.setTemplate(resource.getTemplate());
            return result;
        }
    };
    private static final Equality<Couple<TemplateResource>> COMPARER = new Equality<Couple<TemplateResource>>(){

        public boolean equals(Couple<TemplateResource> o1, Couple<TemplateResource> o2) {
            return this.equals((TemplateResource)o1.first, (TemplateResource)o2.first) && this.equals((TemplateResource)o1.second, (TemplateResource)o2.second);
        }

        private boolean equals(TemplateResource r1, TemplateResource r2) {
            return Objects.equals(r1.getTemplate(), r2.getTemplate()) && Objects.equals(r1.getFileName(), r2.getFileName());
        }
    };
    private final Project myProject;
    private final EqualsHashCodeTemplatesManager myManager;

    public EqualsHashCodeTemplatesPanel(Project project, EqualsHashCodeTemplatesManager manager) {
        super(NAMER, FACTORY, CLONER, COMPARER, new ArrayList<Couple<TemplateResource>>(manager.getTemplateCouples()));
        this.myProject = project;
        this.myManager = manager;
    }

    @Nls
    public String getDisplayName() {
        return JavaBundle.message((String)"configurable.EqualsHashCodeTemplatesPanel.display.name", (Object[])new Object[0]);
    }

    protected String subjDisplayName() {
        return "template";
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    public boolean isModified() {
        return super.isModified() || !Comparing.equal((Object)this.myManager.getDefaultTemplate(), (Object)((Couple)this.getSelectedItem()).first);
    }

    protected boolean canDelete(Couple<TemplateResource> item) {
        return !((TemplateResource)item.first).isDefault();
    }

    protected UnnamedConfigurable createConfigurable(Couple<TemplateResource> item) {
        final GenerateTemplateConfigurable equalsConfigurable = new GenerateTemplateConfigurable((TemplateResource)item.first, GenerateEqualsHelper.getEqualsImplicitVars(this.myProject), this.myProject);
        final GenerateTemplateConfigurable hashCodeConfigurable = new GenerateTemplateConfigurable((TemplateResource)item.second, GenerateEqualsHelper.getHashCodeImplicitVars(), this.myProject);
        return new UnnamedConfigurable(){

            @Nullable
            public JComponent createComponent() {
                Splitter splitter = new Splitter(true);
                JPanel eqPanel = new JPanel(new BorderLayout());
                eqPanel.add((Component)new TitledSeparator(JavaBundle.message((String)"generate.equals.template.title", (Object[])new Object[0])), "North");
                JComponent eqPane = equalsConfigurable.createComponent();
                eqPane.setPreferredSize((Dimension)JBUI.size((int)300, (int)200));
                eqPanel.add((Component)eqPane, "Center");
                splitter.setFirstComponent((JComponent)eqPanel);
                JPanel hcPanel = new JPanel(new BorderLayout());
                hcPanel.add((Component)new TitledSeparator(JavaBundle.message((String)"generate.hashcode.template.title", (Object[])new Object[0])), "North");
                JComponent hcPane = hashCodeConfigurable.createComponent();
                hcPane.setPreferredSize((Dimension)JBUI.size((int)300, (int)200));
                hcPanel.add((Component)hcPane, "Center");
                splitter.setSecondComponent((JComponent)hcPanel);
                return splitter;
            }

            public boolean isModified() {
                return equalsConfigurable.isModified() || hashCodeConfigurable.isModified();
            }

            public void apply() throws ConfigurationException {
                equalsConfigurable.apply();
                hashCodeConfigurable.apply();
            }

            public void reset() {
                equalsConfigurable.reset();
                hashCodeConfigurable.reset();
            }

            public void disposeUIResources() {
                equalsConfigurable.disposeUIResources();
                hashCodeConfigurable.disposeUIResources();
            }
        };
    }

    public void apply() throws ConfigurationException {
        super.apply();
        ArrayList<Object> resources = new ArrayList<Object>();
        for (Couple resource : this.getItems()) {
            resources.add(resource.first);
            resources.add(resource.second);
        }
        this.myManager.setTemplates(resources);
        Couple selection = (Couple)this.getSelectedItem();
        if (selection != null) {
            this.myManager.setDefaultTemplate((TemplateResource)selection.first);
        }
    }
}

