/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenerateSuperMethodCallHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GenerateSuperMethodCallHandler.class);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiMethod method = GenerateSuperMethodCallHandler.canInsertSuper(editor, file);
        LOG.assertTrue(method != null);
        PsiMethod template = (PsiMethod)method.copy();
        OverrideImplementUtil.setupMethodBody(template, method, method.getContainingClass());
        PsiCodeBlock templateBody = template.getBody();
        LOG.assertTrue(templateBody != null, (Object)template);
        PsiStatement superCall = templateBody.getStatements()[0];
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
        LOG.assertTrue(codeBlock != null);
        PsiElement toGo = codeBlock.getLBrace() == null ? codeBlock.addBefore((PsiElement)superCall, null) : (element.getParent() == codeBlock ? codeBlock.addBefore((PsiElement)superCall, element) : codeBlock.addAfter((PsiElement)superCall, (PsiElement)codeBlock.getLBrace()));
        toGo = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)toGo);
        editor.getCaretModel().moveToOffset(toGo.getTextOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public static PsiMethod canInsertSuper(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
        if (codeBlock == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)codeBlock, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (method == null) {
            return null;
        }
        List superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            if (superSignature.getMethod().hasModifierProperty("abstract")) continue;
            return method;
        }
        return null;
    }
}

