/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OverrideImplementsAnnotationsHandler {
    public static final ExtensionPointName<OverrideImplementsAnnotationsHandler> EP_NAME;

    @Contract(pure=true)
    default public String[] getAnnotations(@NotNull PsiFile file) {
        return this.getAnnotations(file.getProject());
    }

    @Deprecated
    @Contract(pure=true)
    public String[] getAnnotations(Project var1);

    @Deprecated
    @Contract(pure=true)
    default public String @NotNull [] annotationsToRemove(Project project, @NotNull String fqName) {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    default public void cleanup(PsiModifierListOwner source, @Nullable PsiElement targetClass, PsiModifierListOwner target) {
    }

    public static void repeatAnnotationsFromSource(PsiModifierListOwner source, @Nullable PsiElement targetClass, PsiModifierListOwner target) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(targetClass != null ? targetClass : target));
        GlobalSearchScope moduleScope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : null;
        Project project = target.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (OverrideImplementsAnnotationsHandler each : EP_NAME.getExtensionList()) {
            for (String annotation : each.getAnnotations(target.getContainingFile())) {
                int flags;
                if (moduleScope != null && facade.findClass(annotation, moduleScope) == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)source, (String)annotation, (int)(flags = 10)) || AnnotationUtil.isAnnotated((PsiModifierListOwner)target, (String)annotation, (int)flags)) continue;
                each.transferToTarget(annotation, source, target);
            }
        }
        for (OverrideImplementsAnnotationsHandler each : EP_NAME.getExtensionList()) {
            each.cleanup(source, targetClass, target);
        }
    }

    default public void transferToTarget(String annotation, PsiModifierListOwner source, PsiModifierListOwner target) {
        PsiModifierList modifierList = target.getModifierList();
        if (!1.$assertionsDisabled && modifierList == null) {
            throw new AssertionError(target);
        }
        PsiAnnotation srcAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)source, (String[])new String[]{annotation});
        PsiNameValuePair[] valuePairs = srcAnnotation != null ? srcAnnotation.getParameterList().getAttributes() : PsiNameValuePair.EMPTY_ARRAY;
        AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent(annotation, valuePairs, (PsiAnnotationOwner)modifierList);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        EP_NAME = ExtensionPointName.create((String)"com.intellij.overrideImplementsAnnotationsHandler");
    }
}

