/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import org.jetbrains.annotations.NotNull;

public class JavaOverrideMethodsHandler
implements ContextAwareActionHandler,
LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile) && !(file instanceof PsiCodeFragment)) {
            return false;
        }
        return OverrideImplementUtil.getContextClass(file.getProject(), editor, file, true) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiClass aClass = OverrideImplementUtil.getContextClass(project, editor, file, true);
        if (aClass == null) {
            return;
        }
        if (OverrideImplementExploreUtil.getMethodSignaturesToOverride(aClass).isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "No methods to override have been found");
            return;
        }
        OverrideImplementUtil.chooseAndOverrideMethods(project, editor, aClass);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiClass aClass = OverrideImplementUtil.getContextClass(file.getProject(), editor, file, true);
        return aClass != null && !OverrideImplementExploreUtil.getMethodSignaturesToOverride(aClass).isEmpty();
    }
}

