/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.folding.impl.JavaFoldingBuilderBase;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class JavaFoldingBuilder
extends JavaFoldingBuilderBase {
    @Override
    protected boolean isBelowRightMargin(@NotNull PsiFile file, int lineLength) {
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file);
        return lineLength <= settings.getRightMargin((Language)JavaLanguage.INSTANCE);
    }

    @Override
    protected boolean shouldShowExplicitLambdaType(@NotNull PsiAnonymousClass anonymousClass, @NotNull PsiNewExpression expression2) {
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiAssignmentExpression) {
            return true;
        }
        ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)expression2, false);
        return types.length != 1 || !types[0].getType().equals(anonymousClass.getBaseClassType());
    }

    @Override
    @NotNull
    protected String rightArrow() {
        return JavaFoldingBuilder.getRightArrow();
    }

    @NotNull
    public static String getRightArrow() {
        return EditorUtil.displayCharInEditor((char)'\u2192', (TextAttributesKey)EditorColors.FOLDED_TEXT_ATTRIBUTES, (String)"->");
    }
}

