/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.externalAnnotation.location;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationsLocation {
    @NotNull
    private final String myGroupId;
    @NotNull
    private final String myArtifactId;
    @NotNull
    private final String myVersion;
    @NotNull
    private final List<String> myRepositoryUrls;

    public AnnotationsLocation(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, String ... repositoryUrls) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myRepositoryUrls = new SmartList((Object[])repositoryUrls);
    }

    @NotNull
    public String getGroupId() {
        return this.myGroupId;
    }

    @NotNull
    public String getArtifactId() {
        return this.myArtifactId;
    }

    @NotNull
    public String getVersion() {
        return this.myVersion;
    }

    @NotNull
    public Collection<String> getRepositoryUrls() {
        return Collections.unmodifiableList(this.myRepositoryUrls);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationsLocation)) {
            return false;
        }
        AnnotationsLocation location = (AnnotationsLocation)o;
        if (!this.myGroupId.equals(location.myGroupId)) {
            return false;
        }
        if (!this.myArtifactId.equals(location.myArtifactId)) {
            return false;
        }
        if (!this.myVersion.equals(location.myVersion)) {
            return false;
        }
        return this.myRepositoryUrls.equals(location.myRepositoryUrls);
    }

    public int hashCode() {
        int result = this.myGroupId.hashCode();
        result = 31 * result + this.myArtifactId.hashCode();
        result = 31 * result + this.myVersion.hashCode();
        result = 31 * result + this.myRepositoryUrls.hashCode();
        return result;
    }

    public String toString() {
        return "[AnnotationLocation '" + this.myGroupId + ":" + this.myArtifactId + ":" + this.myVersion + "'@'" + StringUtil.join(this.myRepositoryUrls, (String)"; ") + "']";
    }
}

