/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.externalAnnotation;

import com.intellij.codeInsight.externalAnnotation.AnnotationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class NonNlsAnnotationProvider
implements AnnotationProvider {
    @Override
    @NotNull
    public String getName(Project project) {
        return "org.jetbrains.annotations.NonNls";
    }

    @Override
    public boolean isAvailable(PsiModifierListOwner owner2) {
        return owner2 instanceof PsiMethod && NonNlsAnnotationProvider.isString(((PsiMethod)owner2).getReturnType()) || owner2 instanceof PsiVariable && NonNlsAnnotationProvider.isString(((PsiVariable)owner2).getType());
    }

    private static boolean isString(PsiType type2) {
        return type2 != null && TypeUtils.isJavaLangString(type2.getDeepComponentType());
    }

    @Override
    public String @NotNull [] getAnnotationsToRemove(Project project) {
        return new String[]{"org.jetbrains.annotations.Nls"};
    }
}

