/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaWordSelectioner
extends AbstractWordSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e instanceof PsiKeyword) {
            return true;
        }
        if (e instanceof PsiJavaToken) {
            IElementType tokenType = ((PsiJavaToken)e).getTokenType();
            return tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.STRING_LITERAL;
        }
        return false;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        List ranges2 = super.select(e, editorText, cursorOffset, editor);
        if (PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.STRING_LITERAL)) {
            JavaWordSelectioner.killRangesBreakingEscapes(e, ranges2, e.getTextRange());
        }
        return ranges2;
    }

    private static void killRangesBreakingEscapes(PsiElement e, List<TextRange> ranges2, TextRange literalRange) {
        Iterator<TextRange> iterator = ranges2.iterator();
        while (iterator.hasNext()) {
            TextRange each = iterator.next();
            if (!literalRange.contains(each) || literalRange.getStartOffset() >= each.getStartOffset() || e.getText().charAt(each.getStartOffset() - literalRange.getStartOffset() - 1) != '\\') continue;
            iterator.remove();
        }
    }
}

