/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AntLikePropertySelectionHandler
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        Language l = e.getLanguage();
        if (!l.equals(JavaLanguage.INSTANCE) && !l.equals(XMLLanguage.INSTANCE)) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)e, PsiComment.class) == null;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        TextRange range = e.getTextRange();
        int prevLeftChar = 32;
        for (int left = cursorOffset; left >= range.getStartOffset(); --left) {
            char leftChar = editorText.charAt(left);
            if (leftChar == '}') {
                return Collections.emptyList();
            }
            if (leftChar == '$' && prevLeftChar == 123) {
                for (int right = cursorOffset; right < range.getEndOffset(); ++right) {
                    char rightChar = editorText.charAt(right);
                    if (rightChar == '{') {
                        return Collections.emptyList();
                    }
                    if (rightChar != '}') continue;
                    return Arrays.asList(new TextRange(left + 2, right), new TextRange(left, right + 1));
                }
            }
            prevLeftChar = leftChar;
        }
        return Collections.emptyList();
    }
}

