/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.editorActions.smartEnter.AfterSemicolonEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.BlockBraceFixer;
import com.intellij.codeInsight.editorActions.smartEnter.CatchDeclarationFixer;
import com.intellij.codeInsight.editorActions.smartEnter.CommentBreakerEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.DoWhileConditionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.EnumFieldFixer;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.ForStatementFixer;
import com.intellij.codeInsight.editorActions.smartEnter.IfConditionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavadocFixer;
import com.intellij.codeInsight.editorActions.smartEnter.LeaveCodeBlockEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.LiteralFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MethodCallFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingArrayConstructorBracketFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingArrayInitializerBraceFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingCatchBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingClassBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingForBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingForeachBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingIfBranchesFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingMethodBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingReturnExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingSwitchBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingSynchronizedBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingThrowExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingTryBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.MissingWhileBodyFixer;
import com.intellij.codeInsight.editorActions.smartEnter.ParameterListFixer;
import com.intellij.codeInsight.editorActions.smartEnter.ParenthesizedFixer;
import com.intellij.codeInsight.editorActions.smartEnter.PlainEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SemicolonFixer;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SwitchExpressionFixer;
import com.intellij.codeInsight.editorActions.smartEnter.SwitchLabelColonFixer;
import com.intellij.codeInsight.editorActions.smartEnter.TernaryColonFixer;
import com.intellij.codeInsight.editorActions.smartEnter.WhileConditionFixer;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance(JavaSmartEnterProcessor.class);
    private static final Fixer[] ourFixers;
    private static final EnterProcessor[] ourEnterProcessors;
    private static final EnterProcessor[] ourAfterCompletionEnterProcessors;
    private int myFirstErrorOffset = Integer.MAX_VALUE;
    private boolean mySkipEnter;
    private static final int MAX_ATTEMPTS = 20;
    private static final Key<Long> SMART_ENTER_TIMESTAMP;
    private final JavadocFixer myJavadocFixer = new JavadocFixer();

    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.complete.statement");
        return this.invokeProcessor(editor, psiFile, false);
    }

    public boolean processAfterCompletion(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        return this.invokeProcessor(editor, psiFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeProcessor(Editor editor, PsiFile psiFile, boolean afterCompletion) {
        Document document = editor.getDocument();
        CharSequence textForRollback = document.getImmutableCharSequence();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.mySkipEnter = false;
            this.process(editor, psiFile, 0, afterCompletion);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), textForRollback);
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    private void process(@NotNull Editor editor, @NotNull PsiFile file, int attempt, boolean afterCompletion) throws TooManyAttemptsException {
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        try {
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            PsiElement atCaret = this.getStatementAtCaret(editor, file);
            if (atCaret == null) {
                if (this.myJavadocFixer.process(editor, file)) {
                    return;
                }
                if (!new CommentBreakerEnterProcessor().doEnter(editor, (PsiElement)file, false)) {
                    JavaSmartEnterProcessor.plainEnter(editor);
                }
                return;
            }
            ArrayList<PsiElement> queue = new ArrayList<PsiElement>();
            JavaSmartEnterProcessor.collectAllElements(atCaret, queue, true);
            queue.add(atCaret);
            for (PsiElement psiElement : queue) {
                for (Fixer fixer : ourFixers) {
                    fixer.apply(editor, this, psiElement);
                    if (LookupManager.getInstance((Project)file.getProject()).getActiveLookup() != null) {
                        return;
                    }
                    if (!JavaSmartEnterProcessor.isUncommited((Project)file.getProject()) && psiElement.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor, file);
                    this.process(editor, file, attempt + 1, afterCompletion);
                    return;
                }
            }
            this.doEnter(atCaret, editor, afterCompletion);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        PsiFile file;
        Document document;
        if (atCaret == null) {
            return;
        }
        PsiElement parent = atCaret.getParent();
        if (parent instanceof PsiForStatement) {
            atCaret = parent;
        }
        if (parent instanceof PsiIfStatement && atCaret == ((PsiIfStatement)parent).getElseBranch() && (document = (file = atCaret.getContainingFile()).getViewProvider().getDocument()) != null) {
            TextRange elseIfRange = atCaret.getTextRange();
            int lineStart = document.getLineStartOffset(document.getLineNumber(elseIfRange.getStartOffset()));
            CodeStyleManager.getInstance((Project)atCaret.getProject()).reformatText(file, lineStart, elseIfRange.getEndOffset());
            return;
        }
        super.reformat(atCaret);
    }

    private void doEnter(PsiElement atCaret, Editor editor, boolean afterCompletion) throws IncorrectOperationException {
        PsiFile psiFile = atCaret.getContainingFile();
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat((PsiElement)atCaret);
            return;
        }
        RangeMarker rangeMarker = this.createRangeMarker((PsiElement)atCaret);
        this.reformat((PsiElement)atCaret);
        this.commit(editor);
        if (!this.mySkipEnter) {
            atCaret = CodeInsightUtil.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), atCaret.getClass());
            for (EnterProcessor processor2 : afterCompletion ? ourAfterCompletionEnterProcessors : ourEnterProcessors) {
                if (atCaret == null) break;
                if (!processor2.doEnter(editor, (PsiElement)atCaret, JavaSmartEnterProcessor.isModified(editor))) continue;
                rangeMarker.dispose();
                return;
            }
            if (!JavaSmartEnterProcessor.isModified(editor) && !afterCompletion) {
                JavaSmartEnterProcessor.plainEnter(editor);
            } else if (this.myFirstErrorOffset == Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(rangeMarker.getEndOffset());
            } else {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
        }
        rangeMarker.dispose();
    }

    private static void collectAllElements(PsiElement atCaret, List<? super PsiElement> res, boolean recurse) {
        PsiElement[] children;
        res.add(0, (PsiElement)atCaret);
        if (JavaSmartEnterProcessor.doNotStepInto(atCaret)) {
            if (!recurse) {
                return;
            }
            recurse = false;
        }
        for (PsiElement child : children = atCaret.getChildren()) {
            if (atCaret instanceof PsiStatement && child instanceof PsiStatement && (!(atCaret instanceof PsiForStatement) || child != ((PsiForStatement)atCaret).getInitialization())) continue;
            JavaSmartEnterProcessor.collectAllElements(child, res, recurse);
        }
    }

    private static boolean doNotStepInto(PsiElement element) {
        return element instanceof PsiClass || element instanceof PsiCodeBlock || element instanceof PsiStatement || element instanceof PsiMethod;
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        PsiElement atCaret = super.getStatementAtCaret(editor, psiFile);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        if (atCaret instanceof PsiJavaToken && "}".equals(atCaret.getText()) && !((atCaret = atCaret.getParent()) instanceof PsiAnonymousClass) && !(atCaret instanceof PsiArrayInitializerExpression) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiCodeBlock.class).withParent(PsiLambdaExpression.class)).accepts((Object)atCaret)) {
            return null;
        }
        for (PsiElement each : SyntaxTraverser.psiApi().parents((Object)atCaret).skip(1)) {
            if (each instanceof PsiMember || each instanceof PsiImportStatementBase || each instanceof PsiPackageStatement || each instanceof PsiAnnotation && PsiTreeUtil.hasErrorElements((PsiElement)each)) {
                return each;
            }
            if (each instanceof PsiCodeBlock || each instanceof PsiComment) {
                return null;
            }
            if (each instanceof PsiStatement) {
                return each.getParent() instanceof PsiForStatement && !PsiTreeUtil.hasErrorElements((PsiElement)each) ? each.getParent() : each;
            }
            if (!(each instanceof PsiConditionalExpression) || !PsiUtilCore.hasErrorElementChild((PsiElement)each)) continue;
            return each;
        }
        return null;
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            this.commit(editor);
            CommonCodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file).getCommonSettings((Language)JavaLanguage.INSTANCE);
            boolean old = settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement leaf = file.findElementAt(caretOffset - 1);
            PsiElement elt = PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiCodeBlock.class);
            if (elt == null && leaf != null && leaf.getParent() instanceof PsiClass) {
                elt = leaf.getParent();
            }
            this.reformat(elt);
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
            this.reformatBlockParentIfNeeded(editor, file);
        }
    }

    private void reformatBlockParentIfNeeded(@NotNull Editor editor, @NotNull PsiFile file) {
        this.commit(editor);
        PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PsiCodeBlock.class, (boolean)false);
        if (block != null && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiBlockStatement.class, PsiForStatement.class})).accepts((Object)block)) {
            this.reformat(block.getParent().getParent());
        }
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    public void setSkipEnter(boolean skipEnter) {
        this.mySkipEnter = skipEnter;
    }

    protected static void plainEnter(@NotNull Editor editor) {
        JavaSmartEnterProcessor.getEnterHandler().execute(editor, editor.getCaretModel().getCurrentCaret(), ((EditorEx)editor).getDataContext());
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor) {
        Long timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP);
        return editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    static {
        ourEnterProcessors = new EnterProcessor[]{new CommentBreakerEnterProcessor(), new AfterSemicolonEnterProcessor(), new LeaveCodeBlockEnterProcessor(), new PlainEnterProcessor()};
        ourAfterCompletionEnterProcessors = new EnterProcessor[]{new AfterSemicolonEnterProcessor(), new EnterProcessor(){

            @Override
            public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
                return PlainEnterProcessor.expandCodeBlock(editor, psiElement);
            }
        }};
        ArrayList<Fixer> fixers = new ArrayList<Fixer>();
        fixers.add(new LiteralFixer());
        fixers.add(new MethodCallFixer());
        fixers.add(new IfConditionFixer());
        fixers.add(new ForStatementFixer());
        fixers.add(new TernaryColonFixer());
        fixers.add(new WhileConditionFixer());
        fixers.add(new CatchDeclarationFixer());
        fixers.add(new SwitchExpressionFixer());
        fixers.add(new SwitchLabelColonFixer());
        fixers.add(new DoWhileConditionFixer());
        fixers.add(new BlockBraceFixer());
        fixers.add(new MissingIfBranchesFixer());
        fixers.add(new MissingWhileBodyFixer());
        fixers.add(new MissingTryBodyFixer());
        fixers.add(new MissingSwitchBodyFixer());
        fixers.add(new MissingCatchBodyFixer());
        fixers.add(new MissingSynchronizedBodyFixer());
        fixers.add(new MissingForBodyFixer());
        fixers.add(new MissingForeachBodyFixer());
        fixers.add(new ParameterListFixer());
        fixers.add(new MissingMethodBodyFixer());
        fixers.add(new MissingClassBodyFixer());
        fixers.add(new MissingReturnExpressionFixer());
        fixers.add(new MissingThrowExpressionFixer());
        fixers.add(new ParenthesizedFixer());
        fixers.add(new SemicolonFixer());
        fixers.add(new MissingArrayInitializerBraceFixer());
        fixers.add(new MissingArrayConstructorBracketFixer());
        fixers.add(new EnumFieldFixer());
        ourFixers = fixers.toArray(new Fixer[0]);
        SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    }

    public static class TooManyAttemptsException
    extends Exception {
    }
}

