/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class LiteralJoinLinesHandler
implements JoinLinesHandlerDelegate {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_BEFORE_PLUS = 1;
    private static final int STATE_AFTER_PLUS = 2;

    public int tryJoinLines(@NotNull Document doc, @NotNull PsiFile psiFile, int offsetNear, int end) {
        CharSequence text2 = doc.getCharsSequence();
        int start = offsetNear;
        while (text2.charAt(start) == ' ' || text2.charAt(start) == '\t' || text2.charAt(start) == '+') {
            --start;
        }
        if (text2.charAt(start) == '\"') {
            --start;
        }
        if (start < offsetNear) {
            ++start;
        }
        int state = 0;
        int startQuoteOffset = -1;
        PsiElement parentExpression = null;
        block6: for (int j = start; j < doc.getTextLength(); ++j) {
            switch (text2.charAt(j)) {
                case '\t': 
                case ' ': {
                    continue block6;
                }
                case '\"': {
                    PsiJavaToken token = (PsiJavaToken)ObjectUtils.tryCast((Object)psiFile.findElementAt(j), PsiJavaToken.class);
                    if (token == null || token.getTokenType() != JavaTokenType.STRING_LITERAL) {
                        return -1;
                    }
                    if (state == 0) {
                        state = 1;
                        startQuoteOffset = j;
                        parentExpression = token.getParent().getParent();
                        continue block6;
                    }
                    if (state == 2) {
                        if (token.getParent().getParent() != parentExpression) {
                            return -1;
                        }
                        doc.deleteString(startQuoteOffset, j + 1);
                        return startQuoteOffset;
                    }
                    return -1;
                }
                case '+': {
                    if (state != 1) {
                        return -1;
                    }
                    state = 2;
                    continue block6;
                }
                default: {
                    return -1;
                }
            }
        }
        return -1;
    }
}

