/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithQuotesAnnotationParameterValueFix
implements IntentionAction {
    private final PsiAnnotationMemberValue myValue;
    private final PsiType myExpectedType;

    public SurroundWithQuotesAnnotationParameterValueFix(PsiAnnotationMemberValue value2, PsiType expectedType) {
        this.myValue = value2;
        this.myExpectedType = expectedType;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myValue.isValid() || !this.myExpectedType.isValid()) {
            return false;
        }
        PsiClass resolvedType = PsiUtil.resolveClassInType((PsiType)this.myExpectedType);
        if (resolvedType != null && "java.lang.String".equals(resolvedType.getQualifiedName())) {
            return this.myValue instanceof PsiLiteralExpression || this.myValue instanceof PsiReferenceExpression && ((PsiReferenceExpression)this.myValue).resolve() == null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String newText = this.myValue.getText();
        newText = StringUtil.unquoteString((String)newText);
        newText = "\"" + newText + "\"";
        PsiExpression newToken = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newText, null);
        PsiElement newElement = this.myValue.replace((PsiElement)newToken);
        editor.getCaretModel().moveToOffset(newElement.getTextOffset() + newElement.getTextLength());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("surround.annotation.parameter.value.with.quotes", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        return new SurroundWithQuotesAnnotationParameterValueFix((PsiAnnotationMemberValue)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myValue, (PsiFile)target), this.myExpectedType);
    }

    public static void register(@NotNull QuickFixActionRegistrar registrar, @NotNull PsiJavaCodeReferenceElement ref) {
        PsiType returnType;
        PsiElement annotationMethod;
        PsiReference reference;
        PsiElement parent;
        if (ref instanceof PsiReferenceExpression && (parent = ref.getParent()) instanceof PsiNameValuePair && ((PsiNameValuePair)parent).getValue() == ref && (reference = parent.getReference()) != null && (annotationMethod = reference.resolve()) instanceof PsiMethod && (returnType = ((PsiMethod)annotationMethod).getReturnType()) != null) {
            registrar.register((IntentionAction)new SurroundWithQuotesAnnotationParameterValueFix((PsiAnnotationMemberValue)((PsiReferenceExpression)ref), returnType));
        }
    }
}

