/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveNewQualifierFix
implements IntentionAction {
    private final PsiNewExpression expression;
    private final PsiClass aClass;

    public RemoveNewQualifierFix(@NotNull PsiNewExpression expression2, PsiClass aClass) {
        this.expression = expression2;
        this.aClass = aClass;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("remove.qualifier.fix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("remove.qualifier.fix", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.expression.isValid() && (this.aClass == null || this.aClass.isValid()) && BaseIntentionAction.canModify((PsiElement)this.expression);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.expression;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement classReference2 = this.expression.getClassReference();
        this.expression.getQualifier().delete();
        if (this.aClass != null && classReference2 != null) {
            classReference2.bindToElement((PsiElement)this.aClass);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

