/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class QualifyWithThisFix
implements IntentionAction {
    private final PsiClass myContainingClass;
    private final PsiElement myExpression;

    public QualifyWithThisFix(@NotNull PsiClass containingClass, @NotNull PsiElement expression2) {
        this.myContainingClass = containingClass;
        this.myExpression = expression2;
    }

    @NotNull
    public String getText() {
        return JavaAnalysisBundle.message((String)"qualify.with.0.this", (Object[])new Object[]{this.myContainingClass.getName()});
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiThisExpression thisExpression = RefactoringChangeUtil.createThisExpression(PsiManager.getInstance((Project)project), this.myContainingClass);
        ((PsiReferenceExpression)this.myExpression).setQualifierExpression((PsiExpression)thisExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

