/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertReturnStatementsVisitor;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(MethodReturnTypeFix.class);
    private final SmartTypePointer myReturnTypePointer;
    private final boolean myFixWholeHierarchy;
    private final boolean mySuggestSuperTypes;
    private final String myName;
    private final String myCanonicalText;

    public MethodReturnTypeFix(@NotNull PsiMethod method, @NotNull PsiType returnType, boolean fixWholeHierarchy) {
        this(method, returnType, fixWholeHierarchy, false);
    }

    public MethodReturnTypeFix(@NotNull PsiMethod method, @NotNull PsiType returnType, boolean fixWholeHierarchy, boolean suggestSuperTypes) {
        super((PsiElement)method);
        PsiType type2;
        this.myReturnTypePointer = SmartTypePointerManager.getInstance((Project)method.getProject()).createSmartTypePointer(returnType);
        this.myFixWholeHierarchy = fixWholeHierarchy;
        this.mySuggestSuperTypes = suggestSuperTypes;
        this.myName = method.getName();
        if (TypeConversionUtil.isNullType((PsiType)returnType)) {
            returnType = PsiType.getJavaLangObject((PsiManager)method.getManager(), (GlobalSearchScope)method.getResolveScope());
        }
        this.myCanonicalText = fixWholeHierarchy ? ((type2 = MethodReturnTypeFix.getHierarchyAdjustedReturnType(method, returnType)) != null ? type2 : returnType).getCanonicalText() : returnType.getCanonicalText();
    }

    @NotNull
    public String getText() {
        if (!this.mySuggestSuperTypes) {
            return QuickFixBundle.message("fix.return.type.text", this.myName, this.myCanonicalText);
        }
        PsiType type2 = Objects.requireNonNull(this.myReturnTypePointer.getType());
        boolean hasPredecessor = type2.getSuperTypes().length != 0;
        return QuickFixBundle.message(hasPredecessor ? "fix.return.type.or.predecessor.text" : "fix.return.type.text", this.myName, this.myCanonicalText);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.return.type.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiMethod myMethod = (PsiMethod)startElement;
        PsiType myReturnType = this.myReturnTypePointer.getType();
        if (BaseIntentionAction.canModify((PsiElement)myMethod) && myReturnType != null && myReturnType.isValid()) {
            PsiType returnType = myMethod.getReturnType();
            if (returnType == null) {
                return true;
            }
            if (returnType.isValid() && !Comparing.equal((Object)myReturnType, (Object)returnType)) {
                return PsiTypesUtil.allTypeParametersResolved((PsiElement)myMethod, (PsiType)myReturnType);
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiType[] superTypes;
        PsiMethod myMethod = (PsiMethod)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myMethod.getContainingFile())) {
            return;
        }
        PsiType returnType = this.myReturnTypePointer.getType();
        if (returnType == null) {
            return;
        }
        boolean isNullType = TypeConversionUtil.isNullType((PsiType)returnType);
        PsiType myReturnType = isNullType ? PsiType.getJavaLangObject((PsiManager)myMethod.getManager(), (GlobalSearchScope)myMethod.getResolveScope()) : returnType;
        PsiTypeElement typeElement = myMethod.getReturnTypeElement();
        if (typeElement == null) {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)QuickFixBundle.message("fix.return.type.family", new Object[0]), null, () -> MethodReturnTypeFix.addReturnType(project, myMethod, myReturnType), (PsiFile[])new PsiFile[0]);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
        PsiType[] psiTypeArray = superTypes = this.mySuggestSuperTypes ? myReturnType.getSuperTypes() : PsiType.EMPTY_ARRAY;
        if (!isNullType && superTypes.length == 0 || editor == null || ApplicationManager.getApplication().isUnitTestMode()) {
            this.changeReturnType(project, file, editor, myMethod, myReturnType);
            return;
        }
        List<PsiType> returnTypes = MethodReturnTypeFix.getReturnTypes(superTypes, myReturnType);
        if (returnTypes.isEmpty()) {
            return;
        }
        this.selectReturnType(project, file, editor, returnTypes, myReturnType, myMethod);
    }

    private static void addReturnType(@NotNull Project project, @NotNull PsiMethod myMethod, @NotNull PsiType myReturnType) {
        PsiTypeElement typeElement = PsiElementFactory.getInstance((Project)project).createTypeElement(myReturnType);
        myMethod.addBefore((PsiElement)typeElement, (PsiElement)myMethod.getNameIdentifier());
    }

    @NotNull
    private static List<PsiType> getReturnTypes(PsiType @NotNull [] types, @NotNull PsiType defaultType) {
        THashMap map2 = new THashMap();
        String defaultTypeKey = MethodReturnTypeFix.serialize(defaultType);
        map2.put(defaultTypeKey, defaultType);
        Arrays.stream(types).forEach(arg_0 -> MethodReturnTypeFix.lambda$getReturnTypes$1((Map)map2, arg_0));
        ArrayList<PsiType> ordered = new ArrayList<PsiType>();
        StatisticsManager statisticsManager = StatisticsManager.getInstance();
        String statsKey = "IntroduceVariable##" + defaultTypeKey;
        for (StatisticsInfo info : statisticsManager.getAllValues(statsKey)) {
            String typeKey = info.getValue();
            PsiType type2 = (PsiType)map2.get(typeKey);
            if (type2 == null) continue;
            map2.remove(typeKey);
            ordered.add(type2);
        }
        ordered.addAll(map2.values());
        return ordered;
    }

    @NotNull
    private static String serialize(PsiType type2) {
        if (PsiUtil.resolveClassInType((PsiType)type2) instanceof PsiTypeParameter) {
            return type2.getCanonicalText();
        }
        return TypeConversionUtil.erasure((PsiType)type2).getCanonicalText();
    }

    void selectReturnType(final @NotNull Project project, final @NotNull PsiFile file, final @NotNull Editor editor, @NotNull List<PsiType> returnTypes, final @NotNull PsiType myReturnType, final @NotNull PsiMethod myMethod) {
        PsiTypeElement typeElement = myMethod.getReturnTypeElement();
        if (typeElement == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)typeElement);
        builder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(project, returnTypes));
        Template template = (Template)WriteCommandAction.runWriteCommandAction((Project)project, () -> builder.buildInlineTemplate());
        TemplateEditingAdapter listener = new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (brokenOff) {
                    return;
                }
                PsiType newReturnType = myMethod.getReturnType();
                if (newReturnType == null) {
                    return;
                }
                TypeSelectorManagerImpl.typeSelected(newReturnType, myReturnType);
                MethodReturnTypeFix.this.changeReturnType(project, file, editor, myMethod, newReturnType);
            }
        };
        editor.getCaretModel().moveToOffset(typeElement.getTextOffset());
        TemplateManager.getInstance((Project)project).startTemplate(editor, template, (TemplateEditingListener)listener);
    }

    private void changeReturnType(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiMethod myMethod, @NotNull PsiType myReturnType) {
        Editor editorForMethod;
        if (this.myFixWholeHierarchy) {
            PsiType superReturnType;
            PsiMethod superMethod = myMethod.findDeepestSuperMethod();
            PsiType psiType = superReturnType = superMethod == null ? null : superMethod.getReturnType();
            if (superReturnType != null && !Comparing.equal((Object)myReturnType, (Object)superReturnType) && !MethodReturnTypeFix.changeClassTypeArgument(myMethod, project, superReturnType, superMethod.getContainingClass(), editor, myReturnType)) {
                return;
            }
        }
        List<PsiMethod> affectedMethods = this.changeReturnType(myMethod, myReturnType);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiReturnStatement statementToSelect = null;
        if (!PsiType.VOID.equals((Object)myReturnType)) {
            ReturnStatementAdder adder = new ReturnStatementAdder(factory, myReturnType);
            for (PsiMethod affectedMethod : affectedMethods) {
                PsiReturnStatement statement = adder.addReturnForMethod(file, affectedMethod);
                if (statement == null || affectedMethod != myMethod) continue;
                statementToSelect = statement;
            }
        }
        if (statementToSelect != null && (editorForMethod = MethodReturnTypeFix.getEditorForMethod(myMethod, project, editor, file)) != null) {
            MethodReturnTypeFix.selectInEditor((PsiElement)statementToSelect.getReturnValue(), editorForMethod);
        }
    }

    private static Editor getEditorForMethod(PsiMethod myMethod, @NotNull Project project, Editor editor, PsiFile file) {
        PsiFile containingFile = myMethod.getContainingFile();
        if (containingFile != file) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, containingFile.getVirtualFile());
            return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
        return editor;
    }

    private static PsiType getHierarchyAdjustedReturnType(PsiMethod method, @NotNull PsiType returnType) {
        for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
            PsiType superMethodReturnType = superMethod.getReturnType();
            if (superMethodReturnType == null || !superMethodReturnType.isAssignableFrom(returnType)) continue;
            if (superMethodReturnType instanceof PsiClassType && returnType instanceof PsiPrimitiveType) {
                return ((PsiPrimitiveType)returnType).getBoxedType((PsiElement)method);
            }
            return returnType;
        }
        return null;
    }

    @NotNull
    private List<PsiMethod> changeReturnType(PsiMethod method, @NotNull PsiType returnType) {
        PsiMethod[] methods = new PsiMethod[]{method};
        if (this.myFixWholeHierarchy) {
            PsiType type2 = MethodReturnTypeFix.getHierarchyAdjustedReturnType(method, returnType);
            if (type2 != null) {
                returnType = type2;
            } else {
                PsiMethod[] superMethods = method.findDeepestSuperMethods();
                if (superMethods.length > 0) {
                    methods = superMethods;
                }
            }
        }
        MethodSignatureChangeVisitor methodSignatureChangeVisitor = new MethodSignatureChangeVisitor();
        for (PsiMethod targetMethod : methods) {
            methodSignatureChangeVisitor.addBase(targetMethod);
            UsagesAwareChangeSignatureProcessor processor2 = new UsagesAwareChangeSignatureProcessor(method.getProject(), targetMethod, false, null, this.myName, returnType, ParameterInfoImpl.fromMethod(targetMethod), methodSignatureChangeVisitor);
            processor2.run();
        }
        return methodSignatureChangeVisitor.getAffectedMethods();
    }

    static void selectInEditor(@Nullable PsiElement element, Editor editor) {
        LOG.assertTrue(element != null);
        TextRange range = element.getTextRange();
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().setSelection(range.getEndOffset(), range.getStartOffset());
    }

    private static boolean changeClassTypeArgument(PsiMethod myMethod, Project project, PsiType superReturnType, PsiClass superClass, Editor editor, PsiType returnType) {
        PsiSubstitutor superClassSubstitutor;
        PsiType superReturnTypeInBaseClassType;
        if (superClass == null || !superClass.hasTypeParameters()) {
            return true;
        }
        PsiClass superReturnTypeClass = PsiUtil.resolveClassInType((PsiType)superReturnType);
        if (superReturnTypeClass == null || !(superReturnTypeClass instanceof PsiTypeParameter) && !superReturnTypeClass.hasTypeParameters()) {
            return true;
        }
        PsiClass derivedClass = myMethod.getContainingClass();
        if (derivedClass == null) {
            return true;
        }
        PsiReferenceParameterList referenceParameterList = MethodReturnTypeFix.findTypeArgumentsList(superClass, derivedClass);
        if (referenceParameterList == null) {
            return true;
        }
        PsiElement resolve2 = ((PsiJavaCodeReferenceElement)referenceParameterList.getParent()).resolve();
        if (!(resolve2 instanceof PsiClass)) {
            return true;
        }
        PsiClass baseClass = (PsiClass)resolve2;
        if (returnType instanceof PsiPrimitiveType) {
            returnType = ((PsiPrimitiveType)returnType).getBoxedType((PsiElement)derivedClass);
        }
        if ((superReturnTypeInBaseClassType = (superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)baseClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)).substitute(superReturnType)) == null) {
            return true;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
        PsiSubstitutor psiSubstitutor = resolveHelper.inferTypeArguments(PsiTypesUtil.filterUnusedTypeParameters((PsiType)superReturnTypeInBaseClassType, (PsiTypeParameter[])baseClass.getTypeParameters()), new PsiType[]{superReturnTypeInBaseClassType}, new PsiType[]{returnType}, PsiUtil.getLanguageLevel((PsiElement)superClass));
        TypeMigrationRules rules = new TypeMigrationRules(project);
        PsiSubstitutor compoundSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).putAll(psiSubstitutor);
        rules.setBoundScope((SearchScope)new LocalSearchScope((PsiElement)derivedClass));
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, (PsiElement)referenceParameterList, (PsiType)JavaPsiFacade.getElementFactory((Project)project).createType(baseClass, compoundSubstitutor));
        return false;
    }

    @Nullable
    private static PsiReferenceParameterList findTypeArgumentsList(PsiClass superClass, PsiClass derivedClass) {
        PsiReferenceParameterList referenceParameterList = null;
        if (derivedClass instanceof PsiAnonymousClass) {
            referenceParameterList = ((PsiAnonymousClass)derivedClass).getBaseClassReference().getParameterList();
        } else {
            PsiReferenceList extendsList;
            PsiReferenceList implementsList = derivedClass.getImplementsList();
            if (implementsList != null) {
                referenceParameterList = MethodReturnTypeFix.extractReferenceParameterList(superClass, implementsList);
            }
            if (referenceParameterList == null && (extendsList = derivedClass.getExtendsList()) != null) {
                referenceParameterList = MethodReturnTypeFix.extractReferenceParameterList(superClass, extendsList);
            }
        }
        return referenceParameterList;
    }

    @Nullable
    private static PsiReferenceParameterList extractReferenceParameterList(PsiClass superClass, PsiReferenceList extendsList) {
        for (PsiJavaCodeReferenceElement referenceElement : extendsList.getReferenceElements()) {
            PsiElement element = referenceElement.resolve();
            if (!(element instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)element), (PsiClass)superClass, (boolean)true)) continue;
            return referenceElement.getParameterList();
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void lambda$getReturnTypes$1(Map map2, PsiType t) {
        map2.put(MethodReturnTypeFix.serialize(t), t);
    }

    private static class UsagesAwareChangeSignatureProcessor
    extends ChangeSignatureProcessor {
        private final UsageVisitor myUsageVisitor;

        private UsagesAwareChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, @PsiModifier.ModifierConstant String newVisibility, String newName, PsiType newType, ParameterInfoImpl @NotNull [] parameterInfo, UsageVisitor usageVisitor) {
            super(project, method, generateDelegate, newVisibility, newName, newType, parameterInfo);
            this.myUsageVisitor = usageVisitor;
        }

        @Override
        protected void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
            this.myUsageVisitor.preprocessCovariantOverriders(covariantOverriderInfos);
        }

        protected void performRefactoring(UsageInfo @NotNull [] usages) {
            super.performRefactoring(usages);
            for (UsageInfo usage : usages) {
                this.myUsageVisitor.visit(usage);
            }
        }
    }

    private static interface UsageVisitor {
        public void visit(UsageInfo var1);

        public void preprocessCovariantOverriders(List<UsageInfo> var1);
    }

    private static class MethodSignatureChangeVisitor
    implements UsageVisitor {
        private final List<PsiMethod> myAffectedMethods = new ArrayList<PsiMethod>();

        private MethodSignatureChangeVisitor() {
        }

        public void addBase(PsiMethod baseMethod) {
            this.myAffectedMethods.add(baseMethod);
        }

        @Override
        public void visit(UsageInfo usage) {
            if (usage instanceof OverriderUsageInfo) {
                this.myAffectedMethods.add(((OverriderUsageInfo)usage).getOverridingMethod());
            }
        }

        public List<PsiMethod> getAffectedMethods() {
            return this.myAffectedMethods;
        }

        @Override
        public void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
            Iterator<UsageInfo> usageInfoIterator = covariantOverriderInfos.iterator();
            while (usageInfoIterator.hasNext()) {
                OverriderUsageInfo overrideUsage;
                UsageInfo info = usageInfoIterator.next();
                if (!(info instanceof OverriderUsageInfo) || !this.myAffectedMethods.contains((overrideUsage = (OverriderUsageInfo)info).getOverridingMethod())) continue;
                usageInfoIterator.remove();
            }
        }
    }

    private static class ReturnStatementAdder {
        @NotNull
        private final PsiElementFactory factory;
        @NotNull
        private final PsiType myTargetType;

        private ReturnStatementAdder(@NotNull PsiElementFactory factory, @NotNull PsiType targetType) {
            this.factory = factory;
            this.myTargetType = targetType;
        }

        private PsiReturnStatement addReturnForMethod(PsiFile file, PsiMethod method) {
            PsiModifierList modifiers = method.getModifierList();
            if (modifiers.hasModifierProperty("abstract") || method.getBody() == null) {
                return null;
            }
            try {
                ControlFlow controlFlow;
                ConvertReturnStatementsVisitor visitor2 = new ConvertReturnStatementsVisitor(this.factory, method, this.myTargetType);
                try {
                    controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)method.getBody());
                }
                catch (AnalysisCanceledException e) {
                    return null;
                }
                PsiReturnStatement returnStatement = ControlFlowUtil.processReturns(controlFlow, visitor2) ? visitor2.getLatestReturn() : visitor2.createReturnInLastStatement();
                if (method.getContainingFile() != file) {
                    UndoUtil.markPsiFileForUndo((PsiFile)file);
                }
                return returnStatement;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
    }
}

