/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(MethodParameterFix.class);
    private final PsiType myParameterType;
    private final int myIndex;
    private final boolean myFixWholeHierarchy;
    private final String myName;

    public MethodParameterFix(PsiMethod method, PsiType type2, int index, boolean fixWholeHierarchy) {
        super((PsiElement)method);
        this.myParameterType = type2;
        this.myIndex = index;
        this.myFixWholeHierarchy = fixWholeHierarchy;
        this.myName = method.getName();
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("fix.parameter.type.text", this.myName, this.myParameterType.getCanonicalText());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.parameter.type.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiMethod myMethod = (PsiMethod)startElement;
        if (!BaseIntentionAction.canModify((PsiElement)myMethod) || this.myParameterType == null || TypeConversionUtil.isNullType((PsiType)this.myParameterType)) {
            return false;
        }
        PsiParameter parameter2 = myMethod.getParameterList().getParameter(this.myIndex);
        return parameter2 != null && !Comparing.equal((Object)this.myParameterType, (Object)parameter2.getType());
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiMethod myMethod = (PsiMethod)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myMethod.getContainingFile())) {
            return;
        }
        try {
            PsiMethod method = myMethod;
            if (this.myFixWholeHierarchy && (method = myMethod.findDeepestSuperMethod()) == null) {
                method = myMethod;
            }
            PsiMethod finalMethod = method;
            ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(project, finalMethod, false, null, finalMethod.getName(), finalMethod.getReturnType(), this.getNewParametersInfo(finalMethod));
            processor2.run();
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private ParameterInfoImpl @NotNull [] getNewParametersInfo(PsiMethod method) throws IncorrectOperationException {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)method.getProject());
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, this.myParameterType);
        PsiParameter newParameter = factory.createParameter(nameInfo.names[0], this.myParameterType);
        if (method.getContainingClass().isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)newParameter, (String)"final", (boolean)false);
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            if (i == this.myIndex) {
                newParameter.setName(parameter2.getName());
                parameter2 = newParameter;
            }
            result.add(ParameterInfoImpl.create(i).withName(parameter2.getName()).withType(parameter2.getType()));
        }
        if (parameters2.length == this.myIndex) {
            result.add(ParameterInfoImpl.createNew().withName(newParameter.getName()).withType(newParameter.getType()));
        }
        return result.toArray(new ParameterInfoImpl[0]);
    }
}

