/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiProvidesStatement;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeProvidesStatementsFix
extends MergeModuleStatementsFix<PsiProvidesStatement> {
    private final String myInterfaceName;

    MergeProvidesStatementsFix(@NotNull PsiJavaModule javaModule, @NotNull String interfaceName) {
        super(javaModule);
        this.myInterfaceName = interfaceName;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("java.9.merge.module.statements.fix.name", "provides", this.myInterfaceName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("java.9.merge.module.statements.fix.family.name", "provides");
    }

    @Override
    @NotNull
    protected String getReplacementText(@NotNull List<? extends PsiProvidesStatement> statementsToMerge) {
        List<String> implementationNames = MergeProvidesStatementsFix.getImplementationNames(statementsToMerge);
        LOG.assertTrue(!implementationNames.isEmpty());
        return "provides " + this.myInterfaceName + ' ' + "with" + ' ' + MergeProvidesStatementsFix.joinUniqueNames(implementationNames);
    }

    @NotNull
    private static List<String> getImplementationNames(@NotNull List<? extends PsiProvidesStatement> statements) {
        return StreamEx.of(statements).map(PsiProvidesStatement::getImplementationList).nonNull().flatMap(implementationList -> Arrays.stream(implementationList.getReferenceElements())).nonNull().map(PsiJavaCodeReferenceElement::getQualifiedName).nonNull().toList();
    }

    @Override
    @NotNull
    protected List<PsiProvidesStatement> getStatementsToMerge(@NotNull PsiJavaModule javaModule) {
        return ((StreamEx)StreamEx.of(javaModule.getProvides().iterator()).filter(statement -> {
            PsiJavaCodeReferenceElement reference = statement.getInterfaceReference();
            return reference != null && this.myInterfaceName.equals(reference.getQualifiedName());
        })).toList();
    }

    @Nullable
    public static MergeModuleStatementsFix<?> createFix(@Nullable PsiProvidesStatement statement) {
        String interfaceName;
        PsiJavaCodeReferenceElement interfaceReference;
        PsiElement parent;
        if (statement != null && (parent = statement.getParent()) instanceof PsiJavaModule && (interfaceReference = statement.getInterfaceReference()) != null && (interfaceName = interfaceReference.getQualifiedName()) != null) {
            return new MergeProvidesStatementsFix((PsiJavaModule)parent, interfaceName);
        }
        return null;
    }
}

