/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetBrainsAnnotationsExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final String VERSION = "19.0.0";
    private static final ExternalLibraryDescriptor JAVA5 = new ExternalLibraryDescriptor("org.jetbrains", "annotations-java5", null, null, "19.0.0");
    private static final ExternalLibraryDescriptor JAVA8 = new ExternalLibraryDescriptor("org.jetbrains", "annotations", null, null, "19.0.0");

    @Override
    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (AnnotationUtil.isJetbrainsAnnotation((String)shortClassName)) {
            ExternalLibraryDescriptor libraryDescriptor = JetBrainsAnnotationsExternalLibraryResolver.getAnnotationsLibraryDescriptor(contextModule);
            return new ExternalLibraryResolver.ExternalClassResolveResult("org.jetbrains.annotations." + shortClassName, libraryDescriptor);
        }
        return null;
    }

    @NotNull
    public static ExternalLibraryDescriptor getAnnotationsLibraryDescriptor(@NotNull Module contextModule) {
        boolean java8 = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)contextModule).isAtLeast(LanguageLevel.JDK_1_8);
        return java8 ? JAVA8 : JAVA5;
    }

    public static String getVersion() {
        return VERSION;
    }
}

